eval 'exec perl -x $0 ${1+"$@"}' # -*-perl-*-
  if 0;
#!perl -w
#
# ======================================================================
# This file is Copyright 1998,1999 by the Purdue Research Foundation and
# may only be used under license.  For terms of the license, see the
# file named COPYRIGHT included with this software release.
# AAFID is a trademark of the Purdue Research Foundation.
# All rights reserved.
# ======================================================================
#
# AAFID2 system
# Agent name:        SU
# Agent description: monitor of su execution.
# Author:            Susana Soriano
#
# History of modifications:
# 
# Known bugs:
# 
# Things to do:
# 
# Future work:
# 
# Suggestions made by people:
# 
# Generated automatically by ../bin/makeagent.pl on Tue Sep  7 23:55:55 1999.
# 
###### AUTOMATICALLY GENERATED FILE --- DO NOT EDIT ##########
#

# 9 "SU.aas"
package SU;

# Version number
# 19 "SU.aas"
$VERSION=eval {1.0}; $VERSION=$VERSION;

# Agent parameters
%PARAMETERS=(
             Description        => "monitor of su execution.",
             CheckPeriod        => eval {8},
# 23 "SU.aas"
             MyFileToCheck => "/var/adm/sulog",
             MyDefaultMessage => 'No executions of su',
             FiltersNeeded => {  }
            );

# Package loading
use AAFID::Agent;
use AAFID::Log;
use AAFID::Common;
# 25 "SU.aas"
use IO::File;

use vars qw (
             @ISA
             $VERSION
             %PARAMETERS
            );

# Define the superclass.
 @ISA=qw(AAFID::Agent);

=head1 SU

This agent examines and reports the execution of the su
command. The status of SU agent will be changed depend on how many su
commands are being executed. If the status goes over 10, it is set to 10.
	The command delete_user(User) is useful for taking out 
logins which are not wanted to be monitored. An account can be put back 
with the command add_user(User). The variable status can be reverted to 
zero with the command clear_status(). Finally, the command setfile(File) 
defines the file where the su command logs its records.

=cut

# Preamble code
# 28 "SU.aas"
sub openfile {
	my $self=checkref(shift);
   	my $fname=shift;
  	if ($fname) {
    	my $file=IO::File->new($fname);
        if (!$file) {
      	$self->Log("errors", "Error opening $fname: $!\n");
     	 return undef;
    	}
    	$self->Log("debug", "File $fname opened successfully.\n");
    	$self->setParameter(MyFileHandle => $file);
    	$file->seek(0,2);
    	return $self;
  	}
  	else {
    	$self->Log("debug", "No file name provided, waiting.\n");
    	return $self;
  	}
}

# Provide an Init function.
sub Init {
  my $self=checkref(shift);
# 50 "SU.aas"
	$self->openfile($Params{MyFileToCheck}) or return undef;
	$self->Log_activate("debug");
	return $self;
        #seek(SULOG,0,2);
  return $self;
}

# The Check function.
sub Check {
  my $self=checkref(shift);
# 56 "SU.aas"
        my $message="";
	my $state=0;
  	my $file=$Params{MyFileHandle};
	my @names=keys %{$Params{MyAccess}};
        $file->seek(0,1);
        while(<$file>){
           @data=split;
           $Params{MyAccess}->{$data[6]}->{$data[7]}++;
	}
	foreach $name (@names) {
	my $temp=0;
       	 if (!$Params{MyAccess}->{$name}->{_Flag}) {
	  foreach $number (keys %{$Params{MyAccess}->{$name}}) {
              	$state+=$Params{MyAccess}->{$name}->{$number};
		$temp+=$Params{MyAccess}->{$name}->{$number};
		}
	  $message .= "$name:$temp:";
	 }
	}
	if ($state >= 10) {
		$state=10;
	}
	$message=$Params{MyDefaultMessage} if !$message;
        return ($state, $message);
}
# Agent commands

sub command_DELETE_USER {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{User}) && 1) {
    my $User = $p{User};
# 94 "SU.aas"
	my @userlist;
  	if (ref($User) eq 'ARRAY') {
		@userlist=@$User;
	}
	else {
		@userlist=splitList($User);
	}
	foreach $file (@userlist) {
                $Params{MyAccess}->{$file}->{_Flag}=1;
	}
    # By default, return undef
    return undef;
  }
}

sub command_CLEAR_STATUS {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (1) {
    
# 106 "SU.aas"
	$Params{MyAccess}={};
    # By default, return undef
    return undef;
  }
}

sub command_SETFILE {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{File}) && 1) {
    my $File = $p{File};
# 109 "SU.aas"
    $self->Log("debug", "Setting file to monitor: $File\n");
    $Params{MyFileToCheck}=$File;
    if ($self->openfile($File)) {
      return undef;
    }
    else {
      return {Error => "Error opening $File: $!"};
    }
    # By default, return undef
    return undef;
  }
}

sub command_ADD_USER {
  my $self=checkref(shift);
  my ($message, %p)=@_;
  if (exists($p{User}) && 1) {
    my $User = $p{User};
# 82 "SU.aas"
	my @userlist;
  	if (ref($User) eq 'ARRAY') {
		@userlist=@$User;
	}
	else {
		@userlist=splitList($User);
	}
	foreach $file (@userlist) {
		$Params{MyAccess}->{$file}->{_Flag}=0;
	}
    # By default, return undef
    return undef;
  }
}

# End of entity marker
_EndOfEntity;
