<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

function acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname)
{
  if ($alert_port == "" )
     $db=mysql_connect($alert_host, $alert_user, $alert_password);
  else
     $db=mysql_connect($alert_host.':'.$alert_port, $alert_user, $alert_password);

  if ( mysql_errno($db) > 0 )
  {
     echo '<B>Error connecting to DB host: '.$alert_host.'</B>. '.mysql_error($db);
     die();
  }

  mysql_select_db($alert_dbname, $db);
  if ( mysql_errno($db) > 0 )
  {
     echo '<B>Error connecting to database: '.$alert_dbname.'@'.$alert_host.'</B>. '.mysql_error($db);
     die();
  }

  return $db;
}

function InputSafeSQL (&$SQLstr)
/* Removes the escape sequence of \' => ' which arise when a variable containing a '-character is passed
   throught a POST query.  This is needed since otherwise the MySQL parser complains */
{
   $SQLstr = str_replace("\'", "'", $SQLstr);
}

function chk_select($stored_value, $current_value)
{
     if ( $stored_value == $current_value )
          return " SELECTED";
     else
          return " ";
}

function chk_check($stored_value, $current_value)
{
     if ( $stored_value == $current_value )
          return " CHECKED";
     else
          return " ";
}

function verify_db($db, $alert_dbname, $alert_host)
{
  $msg = '<B>The underlying database '.$alert_dbname.'@'.$alert_host.' apears to be invalid</B>';


  $sql = "SELECT ip_src FROM iphdr LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return $msg.'.  <P>It is an older version.  Only alert databases created by Snort 1.7-beta0 
                  or later are supported'; 
/* 
  $sql = "SELECT ag_id FROM acid_ag LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return $msg.'.  <P>Although the database version is fine, the ACID DB structure is not present.  
                     Consult the README file and run the <I>create_acid_tbls.sql</I> script';

  $sql = "SELECT ag_id FROM acid_ag_alert LIMIT 0,1";
  $result = mysql_query($sql, $db);
  if ( mysql_errno($db) > 0 )
     return $msg.'.  <P>Although the database version is fine, the ACID DB structure is not present.  
                     Consult the README file and run the <I>create_acid_tbls.sql</I> script'; 
  */
  return "";
}

function PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view)
{
  if ( $num_result_rows > 0 && $num_result_rows > $show_rows )
  {
     echo '
          <P><CENTER>
             <TABLE BORDER=1>
               <TR><TD ALIGN=CENTER>Query Results<BR>&nbsp'."\n";

     $tmp_num_views = ($num_result_rows / $show_rows);
     $tmp_top = $tmp_bottom = $max_scroll_buttons / 2;

     if ( ($current_view - ($max_scroll_buttons/2)) >= 0 )
        $tmp_bottom = $current_view - $max_scroll_buttons/2;
     else
        $tmp_bottom = 0;

     if ( ($current_view + ($max_scroll_buttons/2)) <= $tmp_num_views )
        $tmp_top = $current_view + $max_scroll_buttons/2;
     else
        $tmp_top = $tmp_num_views;

     /* Show a '<<' symbol of have scrolled beyond the 0 view */
     if ( $tmp_bottom != 0 )
        echo ' << ';

     for ( $i = $tmp_bottom; $i < $tmp_top; $i++)
     {
         if ( $i != $current_view )
            echo '<INPUT TYPE="submit" NAME="submit" VALUE="'.$i.'">'."\n";
         else
            echo '['.$i.'] '."\n";
     }  
     
     /* Show a '>>' symbol if last view is not visible */
     if ( ($tmp_top) < $tmp_num_views )
        echo ' >> ';

     echo '</TD></TR></TABLE></CENTER>';
  }
}

function TCPOption2str($tcpopt_code)
/* per RFC 1072, 1323, 1644 */
{
   switch($tcpopt_code)
   {
      case 2:                  /* TCPOPT_MAXSEG - maximum segment*/ 
          return "MSS";
      case 0:                  /* TCPOPT_EOL */
          return "EOL";
      case 1:                  /* TCPOPT_NOP */
          return "NOP";
      case 3:                  /* TCPOPT_WSCALE (rfc1072)- window scale factor */
          return "WS";
      case 5:                  /* TCPOPT_SACK (rfc1072)- selective ACK */
          return "SACK";
      case 4:                  /* TCPOPT_SACKOK (rfc1072)- selective ACK OK */
          return "SACKOK";
      case 6:                  /* TCPOPT_ECHO (rfc1072)- echo */
          return "Echo";
      case 7:                  /* TCPOPT_ECHOREPLY (rfc1072)- echo reply */
          return "Echo Reply";
      case 8:                  /* TCPOPT_TIMESTAMP (rfc1323)- timestamps */
          return "TS";
      case 11:                 /* TCPOPT_CC (rfc1644)- CC options */
          return "CC";
      case 12:                 /* TCPOPT_CCNEW (rfc1644)- CC options */
          return "CCNEW";
      case 13:                 /* TCPOPT_CCECHO (rfc1644)- CC options */
          return "CCECHO";
      default:
          return $tcpopt_code;
   }
}

function IPOption2str($ipopt_code)
{
   switch($ipopt_code)
   {
      case 7:              /* IPOPT_RR */
          return "RR";
      case 0:              /* IPOPT_EOL */
          return "EOL";
      case 1:              /* IPOPT_NOP */
          return "NOP";
      case 0x44:           /* IPOPT_TS */
          return "TS";
      case 0x82:           /* IPOPT_SECURITY */
          return "SEC";
      case 0x83:           /* IPOPT_LSRR */
          return "LSRR";
      case 0x84:           /* IPOPT_LSRR_E */
          return "LSRR_E";
      case 0x88:           /* IPOPT_SATID */
          return "SID";
      case 0x89:           /* IPOPT_SSRR */
          return "SSRR";
  }
}

function ICMPType2str($icmp_type)
{
  switch ($icmp_type)
  {
      case 0:                             /* ICMP_ECHOREPLY */
          return "Echo Reply";
      case 3:                             /* ICMP_DEST_UNREACH */
          return "Destination Unreachable";
      case 4:                             /* ICMP_SOURCE_QUENCH */
          return "Source Quench";
      case 5:                             /* ICMP_REDIRECT */
          return "Redirect";
      case 8:                             /* ICMP_ECHO */
          return "Echo Request";
      case 9:
          return "Router Advertisement";
      case 10:
          return "Router Solicitation"; 
      case 11:                            /* ICMP_TIME_EXCEEDED */
          return "Time Exceeded";
      case 12:                            /* ICMP_PARAMETERPROB */
          return "Parameter Problem";
      case 13:                            /* ICMP_TIMESTAMP */
          return "Timestamp Request";
      case 14:                            /* ICMP_TIMESTAMPREPLY */
          return "Timestamp Reply";
      case 15:                            /* ICMP_INFO_REQUEST */
          return "Information Request";
      case 16:                            /* ICMP_INFO_REPLY */
          return "Information Reply";
      case 17:                            /* ICMP_ADDRESS */
          return "Address Mask Request";
      case 18:                            /* ICMP_ADDRESSREPLY */
          return "Address Mask Reply";
      default:
          return $icmp_type;
  }
}

function ICMPCode2str($icmp_type, $icmp_code)
{
  if ( $icmp_type == 3 )
  {
     switch ($icmp_code)
     {
        case 0:                                    /* ICMP_NET_UNREACH */
            return "Network Unreachable";
        case 1:                                    /* ICMP_HOST_UNREACH */
            return "Host Unreachable";
        case 2:                                    /* ICMP_PROT_UNREACH */
            return "Protocol Unreachable";
        case 3:                                    /* ICMP_PORT_UNREACH */
            return "Port Unreachable";
        case 4:                                    /* ICMP_FRAG_NEEDED */
            return "Fragmentation Needed/DF set";
        case 5:                                    /* ICMP_SR_FAILED */
            return "Source Route failed";
        case 6:                                    /* ICMP_NET_UNKNOWN */
            return "Network Unknown";
        case 7:                                    /* ICMP_HOST_UNKNOWN */
            return "Host Unknown";
        case 8:                                    /* ICMP_HOST_ISOLATED */
            return "Host Isolated";
        case 9:                                    /* ICMP_NET_ANO */
            return "Network ANO";
        case 10:                                   /* ICMP_HOST_ANO */
            return "Host ANO";
        case 11:                                   /* ICMP_NET_UNR_TOS */
            return "Network Unreach TOS";
        case 12:                                   /* ICMP_HOST_UNR_TOS */
            return "Host Unreach TOS";
        case 13:                                   /* ICMP_PKT_FILTERED */
            return "Packet Filtered";
        case 14:                                   /* ICMP_PREC_VIOLATION */
            return "Precedence violation";
        case 15:                                   /* ICMP_PREC_CUTOFF */
            return "Precedence cut off";
        default:
            return $icmp_code;
     }
  }
  else
     return $icmp_code;
}

function PrintBase64PacketPayload ( $encoded_payload )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     //printf(" len = %d\n", strlen($encoded_payload));
     //printf("%s \n", $encoded_payload);

     $payload = base64_decode($encoded_payload);
     $len = strlen($payload);
     printf(" length = %s\n", strlen($payload));

     for ($i = 0; $i < strlen($payload); $i++ )
     {
          if ( $i % 16 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                echo '  ';
                for ($j = $i-16; $j < $i; $j++ )
                {
                       if ( ord($payload[$j]) > 32 && 
                            ord($payload[$j]) < ord("z"))
                          echo $payload[$j];
                       else
                          echo '.';
                }
             }
             printf("\n%03x : ", $i);
          }

          printf("%s ", bin2hex($payload[$i]) );
     }

     /* print the remained of any ASCII chars */
     if ( ($i % 16) != 0 )
     {
        for ( $j = 0; $j < 16 - ($i % 16); $j++)
            echo '   ';

        echo '  ';
        
        for ( $j = $len - ($i % 16); $j < $len; $j++ )
        {
            if ( ord($payload[$j]) > 32 && 
                 ord($payload[$j]) < ord("z"))
                 echo $payload[$j];
            else
                 echo '.';
        } 
     }
}

function PrintAsciiPacketPayload ( $encoded_payload )
{
     printf("Not implemented yet ...\n");
     return;

     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     //printf(" len = %d\n", strlen($encoded_payload));
     //printf("%s \n", $encoded_payload);

     $payload = base64_decode($encoded_payload);
     $len = strlen($payload);
     printf(" length = %s\n", strlen($payload));

     for ($i = 0; $i < strlen($payload); $i++ )
     {
          if ( $i % 16 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                echo '  ';
                for ($j = $i-16; $j < $i; $j++ )
                {
                       if ( ord($payload[$j]) > 32 && 
                            ord($payload[$j]) < ord("z"))
                          echo $payload[$j];
                       else
                          echo '.';
                }
             }
             printf("\n%03x : ", $i);
          }

          printf("%s ", bin2hex($payload[$i]) );
     }

     /* print the remained of any ASCII chars */
     if ( ($i % 16) != 0 )
     {
        for ( $j = 0; $j < 16 - ($i % 16); $j++)
            echo '   ';

        echo '  ';
        
        for ( $j = $len - ($i % 16); $j < $len; $j++ )
        {
            if ( ord($payload[$j]) > 32 && 
                 ord($payload[$j]) < ord("z"))
                 echo $payload[$j];
            else
                 echo '.';
        } 
     }
}

function PrintHexPacketPayload ( $encoded_payload )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     $payload = $encoded_payload;

     $len = strlen($payload);
     printf(" length = %s\n", strlen($payload));

     for ($i = 0; $i < strlen($payload); $i += 2 )
     {
          if ( $i % 32 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                echo '  ';
                for ($j = $i-32; $j < $i; $j+=2 )
                {
                    $t = hexdec($payload[$j].$payload[$j+1]);
                    if ( $t > 32 && $t < ord("z") && $t != ord("<"))
                          echo chr($t);
                       else
                          echo '.';
                }
             }
             printf("\n%03x : ", $i);
          }
          printf("%s%s ", $payload[$i], $payload[$i+1] );
     }

     /* print the remained of any ASCII chars */
     if ( ($i % 32) != 0 )
     {
        for ( $j = 0; $j < 32 - ($i % 32); $j+=2)
            echo '   ';

        echo '  ';
        
        for ( $j = $len - ($i % 32); $j < $len; $j+=2 )
        {
            $t = hexdec($payload[$j].$payload[$j+1]);
            if ( $t > 32 && $t < ord("z") && $t != ord("<"))
               echo chr($t);
            else
               echo '.';
        } 
     }
}

function PrintPacketPayload($data, $encode_type)
{
     printf("\n<PRE>\n");

     /* print the packet based on encoding type */;
     if ( $encode_type == "1" )
         PrintBase64PacketPayload($data);
     else if ($encode_type == "2" )
         PrintAsciiPacketPayload($data);  
     else if ($encode_type == "0" )
         PrintHexPacketPayload($data); 

     printf("\n</PRE>\n");
}

function PrintPacketLookupBrowseButtons($seq, $save_sql, $db)
{

  $result2 = mysql_query($save_sql, $db);
  $myrow2 = mysql_fetch_row($result2);
  $num_rows = mysql_num_rows($result2);


  echo '<CENTER><P><FONT>';
  if ( $seq > 0 )
  {
     mysql_data_seek($result2, $seq-1);
     $myrow2 = mysql_fetch_row($result2);
     echo '<INPUT TYPE="submit" NAME="submit" VALUE="<< Previous #'.($seq-1).'-('.$myrow2[0].'-'.$myrow2[1].')">';
  }
  else
  {
     echo '[ First ]';
  }

  echo '&nbsp&nbsp&nbsp';
  if ( $seq < $num_rows-1 )
  {
     mysql_data_seek($result2, $seq+1);
     $myrow2 = mysql_fetch_row($result2);
     echo '<INPUT TYPE="submit" NAME="submit" VALUE=">> Next #'.($seq+1).'-('.$myrow2[0].'-'.$myrow2[1].')">';
  }
  else
  {
     echo '[ Last ]';
  }
  
  echo '</FONT></CENTER>';

  mysql_free_result($result2);
}

function PacketLookup($submit, $db, $save_sql, $mod_snort_config)
{
  /* extract the sid and cid from the $submit variable of the form
     #XX-(XX-XX) 
      |   |  |
      |   |  |--- cid
      |   |------ sid
      |---------- sequence number of DB lookup
  */
          strtok($submit, "#");
  $seq = strtok("-");
         strtok("(");
  $sid = strtok("-");
  $cid = strtok(")");

  PrintPacketLookupBrowseButtons($seq, $save_sql, $db);
  echo '<HR>';

  /* Event */
  $sql2 = "SELECT signature, timestamp FROM event WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = mysql_query($sql2, $db);
  $myrow2 = mysql_fetch_row($result2);

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="meta_title" WIDTH=50 ALIGN=CENTER ROWSPAN=2>Meta';
  echo '      <TD>
                  <TABLE BORDER=1 CELLPADDING=2>';
  echo '            <TR><TD CLASS="pl_fieldhdr" >ID #</TD>';
  echo '                <TD CLASS="pl_field">'.($sid." - ".$cid).'</TD></TR>';
  echo '            <TR><TD CLASS="pl_fieldhdr">Time</TD>';
  echo '                <TD CLASS="pl_field">'.$myrow2[1].'</TD></TR>';
  echo '            <TR><TD CLASS="pl_fieldhdr">Signature</TD>';
  echo '                <TD CLASS="pl_field">'.$myrow2[0].'</TD></TR>';
  echo '      
                  </TABLE>
              </TD>
           </TR>';

  $sql4 = "SELECT hostname, interface, filter FROM sensor  WHERE sid='".$sid."'";
  $result4 = mysql_query($sql4, $db);
  $myrow4 = mysql_fetch_row($result4);

  echo '  <TR>
             <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="meta_title" ALIGN=CENTER ROWSPAN=2>Sensor</TD>
                       <TD class="pl_fieldhdr">name</TD>
                       <TD class="pl_fieldhdr">interface</TD>
                       <TD class="pl_fieldhdr">filter</TD></TR>
                  <TR><TD class="pl_field">'.$myrow4[0].'</TD>
                      <TD class="pl_field">'.$myrow4[1].'</TD>
                      <TD class="pl_field">'.
                      ( ($myrow4[2] == "") ? "&nbsp;<I>none</I>&nbsp;" : $myrow4[2] ).'</TD>
                  </TR>
                 </TABLE>     
          </TR>';
  mysql_free_result($result4);

  echo '</TABLE>';

  mysql_free_result($result2);

  /* IP */
  $sql2 = "SELECT ip_src0, ip_src1, ip_src2, ip_src3, ip_dst0, ip_dst1, ip_dst2, ip_dst3, ".
          "ip_ver, ip_hlen, ip_tos, ip_len, ip_id, ip_flags, ip_off, ip_ttl, ip_csum, ip_proto". 
          " FROM iphdr  WHERE sid='".$sid."' AND cid='".$cid."'";

  $result2 = mysql_query($sql2, $db);
  $myrow2 = mysql_fetch_row($result2);

  $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='0'";
  $result3 = mysql_query($sql3, $db);
  $num_opt = mysql_num_rows($result3);

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="ip_title" WIDTH=50 ROWSPAN=3 ALIGN=CENTER>IP';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=2>';
  echo '            <TR><TD class="pl_fieldhdr">source addr</TD>
                        <TD class="pl_fieldhdr">&nbsp dest addr &nbsp</TD>
                        <TD class="pl_fieldhdr">Ver</TD>
                        <TD class="pl_fieldhdr">Hdr Len</TD>
                        <TD class="pl_fieldhdr">TOS</TD>
                        <TD class="pl_fieldhdr">length</TD>
                        <TD class="pl_fieldhdr">ID</TD>
                        <TD class="pl_fieldhdr">flags</TD>
                        <TD class="pl_fieldhdr">offset</TD>
                        <TD class="pl_fieldhdr">TTL</TD>
                        <TD class="pl_fieldhdr">chksum</TD></TR>';
  echo '             <TR><TD class="pl_field">'.$myrow2[0].'.'.$myrow2[1].'.'.$myrow2[2].'.'.$myrow2[3].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[4].'.'.$myrow2[5].'.'.$myrow2[6].'.'.$myrow2[7].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[8].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[9].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[10].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[11].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[12].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[13].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[14].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[15].'</TD>';
  echo '                 <TD class="pl_field">'.$myrow2[16].'</TD></TR>';
  echo '         </TABLE>';

  echo '  <TR>
             <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="ip_title" ALIGN=CENTER ROWSPAN=2>FQDN</TD>
                       <TD class="pl_fieldhdr">Source Name</TD>
                       <TD class="pl_fieldhdr">Dest. Name</TD>
                  </TR>
                  <TR><TD class="pl_field">'.
                      (gethostbyaddr($myrow2[0].'.'.$myrow2[1].'.'.$myrow2[2].'.'.$myrow2[3])).'</TD>
                      <TD class="pl_field">'.
                      (gethostbyaddr($myrow2[4].'.'.$myrow2[5].'.'.$myrow2[6].'.'.$myrow2[7])).'</TD>
                  </TR>
                 </TABLE>     
          </TR>';

  echo '  <TR>';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=4>';
  echo '           <TR><TD CLASS="ip_title" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

  $layer4_proto = $myrow2[17];

  if ( $num_opt != 0)
  {
     echo '            <TD></TD>
                       <TD class="pl_fieldhdr">code</TD>
                       <TD class="pl_fieldhdr">length</TD>
                       <TD class="pl_fieldhdr" ALIGN=CENTER>data</TD>';

     for ( $i = 0; $i < $num_opt; $i++)
     {
         $myrow3 = mysql_fetch_row($result3);
         echo '    <TR><TD>#'.($i+1).'</TD>';
         echo '        <TD class="pl_field">'.IPOption2str($myrow3[4]).'</TD>';
         echo '        <TD class="pl_field">'.$myrow3[5].'</TD>';
         echo '        <TD class="pl_field">'.$myrow3[6].'</TD></TR>';             
     }
   }
   else
   {
     echo '             <TD> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
   }
      echo '         </TABLE></TD></TR>';  
                       

  echo '</TABLE>';

  mysql_free_result($result2);
  mysql_free_result($result3);

  /* TCP */
  if ( $layer4_proto == "6" )  
  {
     $sql2 = "SELECT tcp_sport, tcp_dport, tcp_seq, tcp_ack, tcp_off, tcp_res, tcp_flags, tcp_win, ".
             "       tcp_csum, tcp_urp FROM tcphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = mysql_query($sql2, $db);
     $myrow2 = mysql_fetch_row($result2);

     $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='6'";
     $result3 = mysql_query($sql3, $db);
     $num_opt = mysql_num_rows($result3);

      echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4_title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>TCP';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=2>';
      echo '            <TR><TD class="pl_fieldhdr">source<BR> port</TD>
                            <TD class="pl_fieldhdr"> dest<BR> &nbsp port &nbsp</TD>
                            <TD class="pl_fieldhdr">R<BR>1</TD>
                            <TD class="pl_fieldhdr">R<BR>0</TD>
                            <TD class="pl_fieldhdr">U<BR>R<BR>G</TD>
                            <TD class="pl_fieldhdr">A<BR>C<BR>K</TD>
                            <TD class="pl_fieldhdr">P<BR>S<BR>H</TD>
                            <TD class="pl_fieldhdr">R<BR>S<BR>T</TD>
                            <TD class="pl_fieldhdr">S<BR>Y<BR>N</TD>
                            <TD class="pl_fieldhdr">F<BR>I<BR>N</TD>
                            <TD class="pl_fieldhdr">seq #</TD>
                            <TD class="pl_fieldhdr">ack</TD>
                            <TD class="pl_fieldhdr">offset</TD>
                            <TD class="pl_fieldhdr">res</TD>
                            <TD class="pl_fieldhdr">window</TD>
                            <TD class="pl_fieldhdr">urp</TD>
                            <TD class="pl_fieldhdr">chksum</TD></TR>';
      echo '            <TR><TD class="pl_field">'.$myrow2[0].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[1].'</TD>';
      echo '                <TD class="pl_field">';
      if ( ($myrow2[6] & 128) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 64 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 32) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 16 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 8) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 4 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 2 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="pl_field">';
      if ( ($myrow2[6] & 1 ) != 0 )
           echo 'X';
      echo '                    </TD>';
     
      echo '                <TD class="pl_field">'.$myrow2[2].'</TD>';    
      echo '                <TD class="pl_field">'.$myrow2[3].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[4].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[5].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[7].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[9].'</TD>';
      echo '                <TD class="pl_field">'.$myrow2[8].'</TD></TR>';
      echo '         </TABLE></TR></TR>';
      echo '  <TR>';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=4>';
      echo '           <TR><TD CLASS="layer4_title" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

      if ( $num_opt != 0)
      {
         echo '            <TD></TD>
                           <TD class="pl_fieldhdr">code</TD>
                           <TD class="pl_fieldhdr">length</TD>
                           <TD class="pl_fieldhdr">data</TD>';

         for ( $i = 0; $i < $num_opt; $i++)
         {
             $myrow3 = mysql_fetch_row($result3);
             echo '    <TR><TD class="pl_field">#'.($i+1).'</TD>';
             echo '        <TD class="pl_field">'.TCPOption2str($myrow3[4]).'</TD>';
             echo '        <TD class="pl_field">'.$myrow3[5].'</TD>';
             echo '        <TD class="pl_field">'.$myrow3[6].'</TD></TR>';             
         }
      }
      else
      {
         echo '             <TD class="pl_field"> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
      }
      echo '         </TABLE></TD></TR>';                       

      echo '</TABLE>';

      mysql_free_result($result2);
      mysql_free_result($result3);
  }

  /* UDP */
  if ( $layer4_proto == "17" )
  {

     $sql2 = "SELECT * FROM udphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = mysql_query($sql2, $db);
     $myrow2 = mysql_fetch_row($result2);

     echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4_title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>UDP</TD>';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="pl_fieldhdr">source port</TD>
                            <TD class="pl_fieldhdr">dest port</TD>
                            <TD class="pl_fieldhdr">length</TD></TR>';
     echo '            <TR><TD class="pl_field">'.$myrow2[2].'</TD>';
     echo '                <TD class="pl_field">'.$myrow2[3].'</TD>';
     echo '                <TD class="pl_field">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE></TD></TR>';
     echo '</TABLE>';

     mysql_free_result($result2);
  }

  /* ICMP */
  if ( $layer4_proto == "1" )
  {
     $sql2 = "SELECT icmp_type, icmp_code, icmp_csum, icmp_id, icmp_seq FROM icmphdr ".
             "WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = mysql_query($sql2, $db);
     $myrow2 = mysql_fetch_row($result2);

     echo '
           <TABLE BORDER=1>
              <TR><TD class="layer4_title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>ICMP';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="pl_fieldhdr">type</TD>
                           <TD class="pl_fieldhdr">code</TD>
                           <TD class="pl_fieldhdr">checksum</TD>
                           <TD class="pl_fieldhdr">id</TD>
                           <TD class="pl_fieldhdr">seq #</TR>';
     echo '            <TR><TD class="pl_field">'.ICMPType2str($myrow2[0]).'</TD>';
     echo '                <TD class="pl_field">'.ICMPCode2str($myrow2[0],$myrow2[1]).'</TD>';
     echo '                <TD class="pl_field">'.$myrow2[2].'</TD>';
     echo '                <TD class="pl_field">'.$myrow2[3].'</TD>';
     echo '                <TD class="pl_field">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE>';
     echo '</TABLE>';

     mysql_free_result($result2);
  }

  /* Print the Payload */
  $sql2 = "SELECT data_payload FROM data WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = mysql_query($sql2, $db);

  /* get encoding information and detail_level on the payload */
  $sql3 = 'SELECT encoding, detail FROM sensor WHERE sid='.$sid;
  $result3 = mysql_query($sql3, $db);
   $myrow3 = mysql_fetch_row($result3);  
  
  echo '
        <TABLE BORDER=1>
           <TR><TD class="payload_title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>Payload';
  echo '       <TD>';

  if ( mysql_num_rows($result2) != 0 )
  {
     $myrow2 = mysql_fetch_row($result2);

     /* print the packet based on encoding type */
     PrintPacketPayload($myrow2[0], $myrow3[0]);

     mysql_free_result($result3);     
  }
  else
  {
     /* Don't have payload so lets print out why by checking the detail level */

     /* if have fast detail level */
     if ( $myrow[1] == "0" )
        echo '<BR> &nbsp <I>Fast logging used so payload was discarded </I><BR>';
     else
        echo '<BR> &nbsp <I>none </I><BR>';
  }
  echo '</TABLE>';

  mysql_free_result($result2);

  PrintPacketLookupBrowseButtons($seq, $save_sql, $db);
}
?>



















