<?php
/*
** Copyright (C) 2000 Carnegie Mellon University
**
** Authors: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*  
 * Analysis Console for Incident Databases (ACID) by Roman Danyliw
 *
 * This application was developed at the CERT Coordination Center as a part 
 * of the AIRCERT project.
 *
 * See http://www.cert.org/kb/acid for the most up to date 
 * information and documentation about this application.
 *
 * Purpose:
 *
 *   ACID is an PHP-based analysis engine to search and process 
 *   a database of security incidents generated by the NDIS Snort.
 *
 * Configuration:
 *
 *   See the 'README' file, and 'acid.conf'
 *
 * TODO:
 *   - support databases other than MySQL
 *   - netmask (CIDR) as search criteria
 *   - more decode information when printing a packet
 *
 */
?>

<?php
  include ("acid_stat_common.php");
  include("acid_conf.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>

<HEAD>

  <META name="Author" content="Roman Danyliw">
  <TITLE> </TITLE>

  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader"> &nbsp
     <?php
       //include("../hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Snort <U>A</U>nalysis <U>C</U>onsole for <U>I</U>ntrusion <U>D</U>atabases
  </TD>
</TR>
</TABLE>
<P><P>

<?php

  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);

  $tmp_str = verify_db($db, $alert_dbname, $alert_host);
  if ( $tmp_str != "")
  {
     echo $tmp_str;
     die();
  }

  printf("<B>Database:</B> %s\n<BR>\n", 
          ($alert_dbname.'@'.$alert_host. ($alert_port != "" ? ':'.$alert_port : "") ) );
  StartStopTime($start_time, $end_time, $db);
  printf("<B>Time window:</B> [%s] - [%s]\n<P>\n", $start_time, $end_time);

  echo '<TABLE BORDER=1 WIDTH="100%">
        <TR>
           <TD WIDTH="30%">';
             printf("<B># of Sensors:</B> %s<BR>\n", SensorCnt($db));
             printf("<P><B>Unique Alerts:</B> %s<BR>\n", UniqueAlertCnt($db));
             printf("<B>Total Number of Alerts:</B> %s<BR>\n", EventCnt($db));

             printf("<UL><LI>Source IP addresses: %s<BR>\n",  UniqueSrcIPCnt($db));
             printf("    <LI>Dest. IP addresses: %s<BR></UL>\n", UniqueDstIPCnt($db));

  echo '   </TD>
           <TD WIDTH="70%">
             <B>Traffic Profile by Protocol</B>';
             $tcp_cnt = TCPPktCnt($db);
             $udp_cnt = UDPPktCnt($db);
             $icmp_cnt = ICMPPktCnt($db);
             $layer4_cnt = $tcp_cnt + $udp_cnt + $icmp_cnt;

             $tcp_percent = round($tcp_cnt/$layer4_cnt*100);
             $udp_percent = round($udp_cnt/$layer4_cnt*100);
             $icmp_percent = round($icmp_cnt/$layer4_cnt*100);

            if ( $tcp_percent > 0 )   $color = "#FF0000";  else  $color="#FFFFFF";
            echo '<TABLE WIDTH="100%" BORDER=0>
                  <TR><TD>TCP ('.$tcp_percent.'%)</TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$tcp_percent.'%">&nbsp </TD><TD></TD></TR>
                  </TABLE>';

            if ( $udp_percent > 0 )   $color = "#FF0000";  else  $color="#FFFFFF";
            echo '<TABLE WIDTH="100%" BORDER=0>
                  <TR><TD>UDP ('.$udp_percent.'%)</TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$udp_percent.'%">&nbsp </TD><TD></TD></TR>
                  </TABLE>';

            if ( $icmp_percent > 0 )   $color = "#FF0000";  else  $color="#FFFFFF";
            echo '<TABLE WIDTH="100%" BORDER=0>
                  <TR><TD>ICMP ('.$icmp_percent.'%)</TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$icmp_percent.'%">&nbsp </TD><TD></TD></TR>
                  </TABLE>';

  echo '   </TD>
        </TR>
        </TABLE>';
?>

<P>
<LI><B><A HREF="acid_pkt_main.php">Search</A></B>

<P>
<LI><B>Snapshot</B>
<UL>
  <LI><A HREF="acid_stat_alerts.php">Alert Listing</A>
  <LI>Most recent <?php echo $last_num_alerts; ?> Alerts:
      <A HREF="acid_pkt_main.php?caller=last_any&num_result_rows=-1&submit=Last%20Any">any protocol</A>,  
      <A HREF="acid_pkt_main.php?layer4=TCP&caller=last_tcp&num_result_rows=-1&submit=Last%20TCP">TCP</A>,
      <A HREF="acid_pkt_main.php?layer4=UDP&caller=last_udp&num_result_rows=-1&submit=Last%20UDP">UDP</A>,
      <A HREF="acid_pkt_main.php?layer4=ICMP&caller=last_icmp&num_result_rows=-1&submit=Last%20ICMP">ICMP</A>
  <!-- <LI>Most frequent 20 Alerts: TCP, UDP, ICMP -->
  <LI>Graph <A HREF="acid_stat_time.php">Alert detection time</A> 
</UL>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>





