<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include ("acid_common.php");
  include ("acid_stat_common.php");
  include("acid_conf.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>SnortACID: Alert Listing</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Alert Listing</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<?php

  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

  /* Initialized Data */
  if ( $submit == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  /* Moving among the views */
  else
    $current_view = $submit;

  /* Get total number of events */
  $event_cnt = EventCnt($db);

  /* Calculate the Unique Alerts */
  $sql = "SELECT distinctrow signature FROM event";

  /* Run the query to determine the number of rows (No LIMIT)*/
  if ( $num_result_rows == -1 )
  {
     $current_view = 0;
     $result = mysql_query($sql, $db);
     if ( $result  )
     {
        $num_result_rows = mysql_num_rows($result);
        mysql_free_result($result);
     }
     else
        $num_result_rows = 0;
   }

  /* Run the Query again for the actual data (with the LIMIT */
  $limit_tmp = " LIMIT ".($current_view * $show_rows).",".$show_rows;

  if ( $debug_mode == 1 )
     echo $sql.$limit_tmp;

  $result = mysql_query($sql.$limit_tmp, $db);

  /* Print the current view number and # of rows */
  if ( $num_result_rows != 0 )
  {
     printf("<FONT><CENTER>Displaying alerts %d-%d of %d total<BR> (Aggregating %d events)</CENTER></FONT><BR>\n", 
            ($current_view * $show_rows)+1, 
            (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
            (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
            $num_result_rows,
            $event_cnt);
  }
  else
     printf("<P><B>No Alerts were found.  Is the database empty?</B><P>\n");

  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=1>
        <TR>
           <TD CLASS="pl_fieldhdr">Signature</TD>
           <TD CLASS="pl_fieldhdr">Total<BR> Occurences</TD>
           <TD CLASS="pl_fieldhdr">Num of Sensors</TD>
           <TD CLASS="pl_fieldhdr">Unique Src. Addr</TD>
           <TD CLASS="pl_fieldhdr">Unique Dest. Addr</TD>
           <TD CLASS="pl_fieldhdr">First<BR> Occurance</TD>
           <TD CLASS="pl_fieldhdr">Last<BR> Occurance</TD>
        </TR>';

while ( $myrow = mysql_fetch_row ($result) )
{
     $sig_name = $myrow[0];

     /* get Total Occurances */
     $temp = "SELECT count(*) from event where signature=\"".$sig_name."\"";
     $result2 = mysql_query($temp, $db);
     $myrow2 = mysql_fetch_row($result2);
     $total_occurances = $myrow2[0];
     mysql_free_result($result2);

     /* Number of Sensor  */
     $temp = "SELECT distinctrow sid from event where signature=\"".$sig_name."\"";
     $result2 = mysql_query($temp, $db);
     $num_sensors = mysql_num_rows($result2);
     mysql_free_result($result2);

     /* Unique Source Address with this signature */
     $temp = "SELECT distinctrow ip_src from event, iphdr WHERE signature='".$sig_name."' ".
             "AND event.sid=iphdr.sid AND event.cid=iphdr.cid;";
     $result2 = mysql_query($temp, $db);
     $num_src_ip = mysql_num_rows($result2);
     mysql_free_result($result2); 

     /* Unique Dest. Address with this signature */
     $temp = "SELECT distinctrow ip_dst from event, iphdr WHERE signature='".$sig_name."' ".
             "AND event.sid=iphdr.sid AND event.cid=iphdr.cid;";
     $result2 = mysql_query($temp, $db);
     $num_dst_ip = mysql_num_rows($result2);
     mysql_free_result($result2); 

     /* First and Last timestamp of this signature */
     $result2 = mysql_query("SELECT min(timestamp), max(timestamp) FROM event ".
                           "WHERE signature='".$sig_name."';", $db);
     $myrow = mysql_fetch_row($result2);
     $start_time = $myrow[0];
     $stop_time = $myrow[1];
     mysql_free_result($result2);

     /* Print out */ 
     echo '<TR>';
/*     echo '  <TD ALIGN=CENTER><FORM METHOD="post" ACTION="acid_pkt_main.php">
                 <INPUT TYPE=hidden NAME="sig[0]" VALUE="=">
                 <INPUT TYPE=hidden NAME="sig[1]" VALUE="'.$sig_name.'">
                 <INPUT TYPE=hidden NAME="caller" VALUE="stat_alerts">
                 <INPUT TYPE=hidden NAME="num_result_rows" VALUE="-1">
                 <INPUT TYPE=submit NAME="submit" VALUE="'.$sig_name.'">
                 ';*/
     echo '  <TD ALIGN=CENTER><A HREF="acid_pkt_main.php?sig%5B0%5D=%3D&sig%5B1%5D='.
                              (rawurlencode($sig_name)).'&caller=stat_alerts'.
                              '&num_result_rows=-1'.
                              '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+">'.$sig_name.'</A>';
     echo '  <TD ALIGN=CENTER>'.$total_occurances.' ('.(round($total_occurances/$event_cnt*100)).'%)';
     echo '  <TD ALIGN=CENTER>'.$num_sensors;
     echo '  <TD ALIGN=CENTER>'.$num_src_ip;
     echo '  <TD ALIGN=CENTER>'.$num_dst_ip;
     echo '  <TD ALIGN=CENTER>'.$start_time;
     echo '  <TD ALIGN=CENTER VALIGN=CENTER>'.$stop_time;
     echo '  </TR>';
}
mysql_free_result($result);

echo "</TABLE>\n";

echo '<FORM ACTION="acid_stat_alerts.php" METHOD="POST">';
echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';

/* ****** Print out Browsing Buttons ********************************************/
PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);
echo '</FORM>';

  mysql_close($db);
?>



<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>
