<?php
/*
** Copyright (C) 2000 Carnegie Mellon University
**
** Authors: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*  
 * Analysis Console for Incident Databases (ACID) by Roman Danyliw
 *
 * This application was developed at the CERT Coordination Center as a part 
 * of the AIRCERT project.
 *
 * See http://www.cert.org/kb/acid for the most up to date 
 * information and documentation about this application.
 *
 * Purpose:
 *
 *   ACID is an PHP-based analysis engine to search and process 
 *   a database of security incidents generated by the NIDS Snort.
 *
 * Configuration:
 *
 *   See the 'README' file, and 'acid.conf'
 *
 */
?>

<?php
  include("acid_stat_common.php");
  include("acid_conf.php");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>

<HEAD>

  <META name="Author" content="Roman Danyliw">
  <?php
    PrintFreshPage($refresh_stat_page, $stat_page_refresh_time);
  ?>
  <TITLE>Analysis Console for Incident Databases (ACID) </TITLE>

  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader"> &nbsp
     <?php
       //include("../hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle"><U>A</U>nalysis <U>C</U>onsole for <U>I</U>ntrusion <U>D</U>atabases
  </TD>
</TR>
</TABLE>
<P><P>

<?php
  if ( $debug_mode == 1 )
     PrintPageHeader();
//     phpinfo();

  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);

  $tmp_str = verify_db($db, $alert_dbname, $alert_host);
  if ( $tmp_str != "")
  {
     echo $tmp_str;
     die();
  }

  printf("<B>Queried on </B><FONT> : %s<BR>",date("D F d, Y H:i:s",time()));
  printf("<B>Database:</B> %s\n<BR>\n", 
         ($alert_dbname.'@'.$alert_host. ($alert_port != "" ? ':'.$alert_port : "") ) );
  StartStopTime($start_time, $end_time, $db);
  if ( $start_time != "" )
     printf("<B>Time window:</B> [%s] - [%s]\n<P>\n", $start_time, $end_time);
  else
     printf("<B>Time window:</B> <I>no alerts detected</I>\n");

  echo '<TABLE BORDER=1 WIDTH="100%">
        <TR>
           <TD WIDTH="30%">';
	     echo '<B># of Sensors:</B>
                      <A HREF="acid_stat_sensor.php">'.SensorCnt($db).'</A>';

/* XXX - stuart's code
	     $sensor_ids = GetSensorIDs($db);

	     for( $i = 0; $i < SensorCnt($db); $i++) {
	     	printf("Alerts on Sensor %s: %s<BR>\n",  $sensor_ids[$i], EventCntBySensor($sensor_ids[$i], $db)  );
	     }
*/

             echo '<P><B>Unique Alerts:</B> <A HREF="acid_stat_alerts.php">'.UniqueAlertCnt($db).'</A><BR>';
             echo '<B>Total Number of Alerts:</B> 
                      <A HREF="acid_pkt_main.php?&num_result_rows=-1'.
                             '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                             '&submit=Query+DB&current_view=-1">'.EventCnt($db).'</A>';

             echo '<UL><LI>Source IP addresses: '. 
                       BuildUniqueAddressLink("<I>all alerts</I>", 1,
                                      "SELECT DISTINCTROW ip_src, ip_src0, ip_src1, ip_src2, ip_src3 ".
                                      "FROM event, iphdr ".
                                      "WHERE event.sid=iphdr.sid AND event.sid=iphdr.sid ".
                                      "ORDER BY ip_src","").
                        UniqueSrcIPCnt($db).'</A>
                       <LI>Dest. IP addresses: '.
                       BuildUniqueAddressLink("<I>all alerts</I>", 2,
                                      "SELECT DISTINCTROW ip_dst, ip_dst0, ip_dst1, ip_dst2, ip_dst3 ".
                                      "FROM event, iphdr ".
                                      "WHERE event.sid=iphdr.sid AND event.cid=iphdr.cid ".
                                      "ORDER BY ip_dst","").
                       UniqueDstIPCnt($db).'</A>
                   </UL>';

  echo '   </TD>
           <TD WIDTH="70%">
             <B>Traffic Profile by Protocol</B>';
             PrintProtocolProfileGraphs($db);

  echo '   </TD>
        </TR>
        </TABLE>';
?>

<P>
<LI><B><A HREF="acid_pkt_main.php">Search</A></B>

<P>
<LI><B>Snapshot</B>
<UL>
<?php
   $tmp_month = date("m");
   $tmp_day = date("d");
   $tmp_year = date("Y");

   $tmp_today = 'acid_pkt_main.php?time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3D'.
                                 '&time%5B0%5D%5B2%5D='.$tmp_month.
                                 '&time%5B0%5D%5B3%5D='.$tmp_day.
                                 '&time%5B0%5D%5B4%5D='.$tmp_year.
                                 '&time%5B0%5D%5B5%5D=&time%5B0%5D%5B6%5D=&time%5B0%5D%5B7%5D='.
                                 '&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+'.
                                 '&submit=Query+DB&num_result_rows=-1&time_cnt=1';

   $tmp_today_unique = 'acid_stat_alerts.php?criteria='.
                       rawurlencode("SELECT sid, cid FROM event WHERE timestamp >=".
                                    $tmp_year.$tmp_month.$tmp_day."000000 AND timestamp <=".
                                    $tmp_year.$tmp_month.$tmp_day."235959").
                       '&criteria_desc='.
                       rawurlencode("time = [ ".$tmp_month." / ".$tmp_day." / ".$tmp_year." ]".
                                    " [ <I>any time</I> ]");
  echo '
  <LI>Today\'s  <A HREF="'.$tmp_today_unique.'">Unique alerts</A>, 
                <A HREF="'.$tmp_today.'">Alert list</A>';
?>
  <LI>Most <A HREF="acid_stat_alerts.php?caller=last_alerts&sort_order=last">
       recent <?php echo $last_num_ualerts; ?> Unique Alerts</A>
  <LI>Most <A HREF="acid_stat_alerts.php?caller=most_frequent&sort_order=occur_d">
       frequent <?php echo $freq_num_alerts; ?> Alerts</A>

  <LI>Most recent <?php echo $last_num_alerts; ?> Alerts:
      <A HREF="acid_pkt_main.php?caller=last_any&num_result_rows=-1&submit=Last%20Any">any protocol</A>,  
      <A HREF="acid_pkt_main.php?layer4=TCP&caller=last_tcp&num_result_rows=-1&submit=Last%20TCP">TCP</A>,
      <A HREF="acid_pkt_main.php?layer4=UDP&caller=last_udp&num_result_rows=-1&submit=Last%20UDP">UDP</A>,
      <A HREF="acid_pkt_main.php?layer4=ICMP&caller=last_icmp&num_result_rows=-1&submit=Last%20ICMP">ICMP</A>

  <P>
  <LI>Graph alert <A HREF="acid_stat_time.php">detection time</A> 
</UL>

<FONT>
<P>
<LI><B>Alert Group (AG) <A HREF="acid_ag_main.php?action=list">maintenance</A></B>

</FONT>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>





