<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001, 2002 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - submit:
 *   - time:
 *   - time_sep:
 */

  include ("acid_constants.inc");
  include ("acid_conf.php");
  include ("acid_include.inc");
  include_once ("acid_db_common.php");
  include_once ("acid_common.php");
  include_once ("acid_graph_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_stat_alerts.php");
  $cs->ReadState();
  
  session_start();

  $submit = ImportHTTPVar("submit");

  $height = ImportHTTPVar("height");
  $width = ImportHTTPVar("width");  
  $user_chart_title = ImportHTTPVar("user_chart_title");
  $data_source = ImportHTTPVar("data_source");
  $chart_type = ImportHTTPVar("chart_type");
  $chart_interval = ImportHTTPVar("chart_interval");

  $chart_begin_hour = ImportHTTPVar("chart_begin_hour");
  $chart_begin_month = ImportHTTPVar("chart_begin_month");
  $chart_begin_day = ImportHTTPVar("chart_begin_day");
  $chart_begin_year = ImportHTTPVar("chart_begin_year");

  $chart_end_hour = ImportHTTPVar("chart_end_hour");
  $chart_end_month = ImportHTTPVar("chart_end_month");
  $chart_end_day = ImportHTTPVar("chart_end_day");
  $chart_end_year = ImportHTTPVar("chart_end_year");

  $chart_style = ImportHTTPVar("chart_style");
  $rotate_xaxis_lbl = ImportHTTPVar("rotate_xaxis_lbl");
  $yaxis_scale = ImportHTTPVar("yaxis_scale");
  $xaxis_grid = ImportHTTPVar("xaxis_grid");
  $yaxis_grid = ImportHTTPVar("yaxis_grid");

  $pmargin0 = ImportHTTPVar("pmargin0");
  $pmargin1 = ImportHTTPVar("pmargin1");
  $pmargin2 = ImportHTTPVar("pmargin2");
  $pmargin3 = ImportHTTPVar("pmargin3");
  
  $xaxis_label_inc = ImportHTTPVar("xaxis_label_inc");

  $min_size = ImportHTTPVar("min_size");
  $aggregate_type = ImportHTTPVar("aggregate_type");

  $page_title = "Graph Alert Data";
  PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

  LoadGraphingLib($ChartLib_path);

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);
?>


<?php

  if ( ini_get("safe_mode") != true )
     set_time_limit($max_script_runtime);

  /* Set default chart values */
  if ( $submit == "" )
  {
     $height = 400;
     $width = 600;
     $pmargin0 = 50;
     $pmargin1 = 50;
     $pmargin2 = 70;
     $pmargin3 = 80;
     $user_chart_title = "ACID Chart";
     $min_size = 0;
     $rotate_xaxis_lbl = 0;
     $xaxis_label_inc = 1;
     $yaxis_scale = 0;
     $chart_style = "bar";
     $use_alerts = 0;
     $xaxis_grid = 0;
     $yaxis_grid = 1;
  }

  include("acid_graph_form.php");

  $data_pnt_cnt = 0;
  /* Error Conditions */
  //if ( $submit != "" && $data_source == " " )
  //   echo '<FONT><B>No AG was selected for the data source</B>.</FONT>';     
  if ( $submit != "" && $chart_type == " " )
     echo '<FONT><B>No chart type was specified</B>.</FONT>';
  //else if ( $data_source == " " )
  //   echo '<FONT><B>No AG was specified</B>.</FONT>';

  /* Calculate the data set */
  else if ($submit != "")
  {
     if ( $data_source == " " )
     {
        ErrorMessage("No AG was specified.  Using all alerts.");
        $data_source = NULL;
     }

     unset($xdata);
     unset($xlabel);

     if ( $debug_mode > 1 )  echo "<H3>Starting data import ...</H3>";

     /* Building Criteria */
     $time_constraint = ProcessChartTimeConstraint($chart_begin_hour, 
                                                   $chart_begin_day, 
                                                   $chart_begin_month, 
                                                   $chart_begin_year,
                                                   $chart_end_hour,  
                                                   $chart_end_day,  
                                                   $chart_end_month, 
                                                   $chart_end_year );

     $criteria = array(2);
     if ( $data_source != NULL )
     {
        $criteria[0] = "LEFT JOIN acid_ag_alert ".
                      "ON (acid_event.sid=acid_ag_alert.ag_sid AND acid_event.cid=acid_ag_alert.ag_cid) ";
        $criteria[1] = "acid_ag_alert.ag_id = $data_source";

        if ( $time_constraint != NULL )
           $criteria[1] = $criteria[1].$time_constraint; 
     }
     else
     {
        $criteria[0] = "";
        $criteria[1] = "acid_event.sid > 0 ".$time_constraint;
     }

     if ( $debug_mode > 0 ) 
     {
       echo "<H3>Chart criteria</H3><PRE>";
       print_r($criteria);
       echo "</PRE>";
     }

     switch ($chart_type)
     {
         case 1:
         case 2:
         case 3:
         case 4:
         case 5:
         {
            $chart_title = "Time vs. Number of Alerts";
            $xaxis_label = "Time";
            $yaxis_label = "Alert Occurrences";
            $data_pnt_cnt = GetTimeDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            $chart_title = $chart_title."\n ( ".$xdata[0][0]." - ".$xdata[count($xdata)-1][0]." )";
            break;
         }
         case 6:  // Src. IP vs. Num Alerts
         {
            $chart_title = "Source IP vs. Number of Alerts";
            $xaxis_label = "Source IP Address";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetIPDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 7:  // Dst. IP vs. Num Alerts
         {
            $chart_title = "Destination IP vs. Number of Alerts";
            $xaxis_label = "Destination IP Address";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetIPDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 8:  // UDP Port vs. Num Alerts 
         {
            $chart_title = "UDP Port (Destination) vs. Number of Alerts";
            $xaxis_label = "Dst. UDP Port";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 10:  // UDP Port vs. Num Alerts 
         {
            $chart_title = "UDP Port (Source) vs. Number of Alerts";
            $xaxis_label = "Src. UDP Port";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 9:  // TCP Port vs. Num Alerts 
         {
            $chart_title = "TCP Port (Destination) vs. Number of Alerts";
            $xaxis_label = "Dst. TCP Port";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 11:  // TCP Port vs. Num Alerts 
         {
            $chart_title = "TCP Port (Source) vs. Number of Alerts";
            $xaxis_label = "Src. TCP Port";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 12:  // Classification vs. Num Alerts 
         {
            $chart_title = "Signature Classification vs. Number of Alerts";
            $xaxis_label = "Classification";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetClassificationDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
         case 13:  // Sensor vs. Num Alerts 
         {
            $chart_title = "Sensor vs. Number of Alerts";
            $xaxis_label = "Sensor";
            $yaxis_label = "Alert Occurrences";

            $data_pnt_cnt = GetSensorDataSet($xdata, $chart_type, $data_source, $min_size, $criteria);
            break;
         }
     }

     if ( $data_pnt_cnt > 0 )
     {
        if ( $debug_mode > 0 )
        {
           echo "chart_type = $chart_type<BR>
                 data_source = $data_source<BR>";
           echo "<H3>Handling Period if necessary ...</H3>\n";
        }

        if ( $chart_interval ) {
          // set up array
          for ( $i = 0; $i < $chart_interval; $i++ ) {
            $chart_array [$i][0] = $i;
            $chart_array [$i][1] = 0;
          }
          // loading data
          for ( $i = 0; $i < count ($xdata); $i++ ) {
            $chart_array [ $i % $chart_interval ][1] += $xdata [$i][1];
          }
          // set up xdata
          $xdata = $chart_array;
        }

        if ( $debug_mode > 0 )   
           echo "<H3>Dumping data ... (writing only every $xaxis_label_inc)</H3>";
        $data_str = "";
        $data_lbl_str = "";
        for ( $i = 0; $i < count($xdata); $i++)
        {
          if ( $debug_mode > 0 )
             echo $i." -- ".$xdata[$i][0]." - ".$xdata[$i][1]."<BR>";
        
          /* Apply the X-Axis label clean-up -- 
           * only write every N axis labels (erase the rest) 
           */
          if ( ($i % $xaxis_label_inc ) != 0 )
             $xdata[$i][0] = "";
        }

        if ( $debug_mode > 0 )  echo "<H3>Drawing graph ($width x $height)</H3>";

        $et->Mark("Extracting data");
        echo '<CENTER>
              <TABLE BGCOLOR="#000000" CELLSPACING=0 CELLPADDING=2 BORDER=0>
              <TR>
              <TD>';

        $HTTP_SESSION_VARS['xdata'] = $xdata;
        echo "<CENTER>
              <IMG SRC=\"acid_graph_display.php?width=$width&height=$height".
                      "&pmargin0=$pmargin0&pmargin1=$pmargin1".
                      "&pmargin2=$pmargin2&pmargin3=$pmargin3".
                      "&title=".rawurlencode($user_chart_title."\n".$chart_title).
                      "&xaxis_label=".rawurlencode($xaxis_label).
                      "&yaxis_label=".rawurlencode($yaxis_label).
                      "&yaxis_scale=".rawurlencode($yaxis_scale).
                      "&rotate_xaxis_lbl=".rawurlencode($rotate_xaxis_lbl).
                      "&yaxis_scale=".$yaxis_scale.
                      "&xaxis_grid=".$xaxis_grid.
                      "&yaxis_grid=".$yaxis_grid.
                      "&style=".$chart_style."\"></CENTER>";

        echo '</TD>
              </TR>
              </TABLE>
              </CENTER>';
        $et->Mark("Rendering graph");
      }
      else
        ErrorMessage("No data points to plot");
   }

  $et->PrintTiming();

  PrintACIDSubFooter();
?>

