/*en    Laurent Constantin's network library (lcrzo)
                 lcrzo_error module

  Functions herein allow to deal with errors.
*/
/*fr   Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_error

  Les fonctions presentes dans ce module gerent les codes d'erreur
retournes par les fonctions.
*/

/*en Error ranges :
   0..49      : OK codes
   50..99     : lcrzo error codes < 255
   100..249   : user error codes < 255
   250..299   : unused
   300..9999  : lcrzo error codes
   10000..64k : user error codes
So, your own functions can use ranges 100..249 and 10000..64k
*/
/*fr Intervalles d'erreur :
   0..49      : codes OK
   50..99     : codes d'erreur de lcrzo < 255
   100..249   : codes d'erreur utilisateur < 255
   250..299   : non utilise
   300..9999  : codes d'erreur de lcrzo
   10000..64k : codes d'erreur utilisateur
Vos propres fonctions peuvent donc employer les intervalles
100..249 et 10000..64k
*/
#define LCRZO_ERRZONE_OK_BEGIN        0
#define LCRZO_ERRZONE_OK_END         49
#define LCRZO_ERRZONE_LCRZO1_BEGIN   50
#define LCRZO_ERRZONE_LCRZO1_END     99
#define LCRZO_ERRZONE_USER1_BEGIN   100
#define LCRZO_ERRZONE_USER1_END     249
#define LCRZO_ERRZONE_LCRZO2_BEGIN  300
#define LCRZO_ERRZONE_LCRZO2_END   9999
#define LCRZO_ERRZONE_USER2_BEGIN 10000
#define LCRZO_ERRZONE_USER2_END   65535

/*en normal returns */
/*fr retours normaux */
#define LCRZO_ERR_00_BEGIN 0
#define LCRZO_ERR_OK 0
#define LCRZO_ERR_OK_entxt "ok"
#define LCRZO_ERR_OK_frtxt "ok"
#define LCRZO_ERR_OKFINISHLOOP 1
#define LCRZO_ERR_OKFINISHLOOP_entxt "want to finish the loop"
#define LCRZO_ERR_OKFINISHLOOP_frtxt "fin de la boucle demandee"
#define LCRZO_ERR_OKDATAEND 2
#define LCRZO_ERR_OKDATAEND_entxt "end of data"
#define LCRZO_ERR_OKDATAEND_frtxt "fin des donnees"
#define LCRZO_ERR_OKTEMPDATAEND 3
#define LCRZO_ERR_OKTEMPDATAEND_entxt "no more data for the moment"
#define LCRZO_ERR_OKTEMPDATAEND_frtxt "pour le moment, il n'y a pas de donnees a lire"
#define LCRZO_ERR_OKSEARCHNOTFOUND 4
#define LCRZO_ERR_OKSEARCHNOTFOUND_entxt "the searched element wasn't found"
#define LCRZO_ERR_OKSEARCHNOTFOUND_frtxt "la recherche a echouee"
#define LCRZO_ERR_OKNOTDECODED 5
#define LCRZO_ERR_OKNOTDECODED_entxt "the packet cannot be decoded"
#define LCRZO_ERR_OKNOTDECODED_frtxt "le paquet ne peut pas etre decode"
#define LCRZO_ERR_OKUNRESOLVED 6
#define LCRZO_ERR_OKUNRESOLVED_entxt "unresolved address"
#define LCRZO_ERR_OKUNRESOLVED_frtxt "l'adresse n'a pas pu etre resolue"
#define LCRZO_ERR_OKDATATRUNCATED 7
#define LCRZO_ERR_OKDATATRUNCATED_entxt "the data was truncated"
#define LCRZO_ERR_OKDATATRUNCATED_frtxt "les donnees ont ete tronquees"
#define LCRZO_ERR_OKROUTELOCALDEV 8
#define LCRZO_ERR_OKROUTELOCALDEV_entxt "the destination is a local device"
#define LCRZO_ERR_OKROUTELOCALDEV_frtxt "la destination est un device local"
#define LCRZO_ERR_OKROUTEHOSTUNREACH 9
#define LCRZO_ERR_OKROUTEHOSTUNREACH_entxt "destination is on LAN, but is unreachable"
#define LCRZO_ERR_OKROUTEHOSTUNREACH_frtxt "la destination est sur le LAN, mais n'est pas joignable"
#define LCRZO_ERR_OKROUTEGWUNREACH 10
#define LCRZO_ERR_OKROUTEGWUNREACH_entxt "destination is through a router, but the router is unreachable"
#define LCRZO_ERR_OKROUTEGWUNREACH_frtxt "la destination est vers un routeur, mais il n'est pas joignable"
#define LCRZO_ERR_OKROUTENOTFOUND 11
#define LCRZO_ERR_OKROUTENOTFOUND_entxt "no route found to destination"
#define LCRZO_ERR_OKROUTENOTFOUND_frtxt "pas de route trouvee pour la destination"
#define LCRZO_ERR_OKFILENOTFOUND 12
#define LCRZO_ERR_OKFILENOTFOUND_entxt "file not found"
#define LCRZO_ERR_OKFILENOTFOUND_frtxt "fichier non trouve"
#define LCRZO_ERR_OKAVAILDATAOTHTYPE 13
#define LCRZO_ERR_OKAVAILDATAOTHTYPE_entxt "available data is of other type"
#define LCRZO_ERR_OKAVAILDATAOTHTYPE_frtxt "les donnees presentes sont d'un autre type"
#define LCRZO_ERR_OKPROCESSABRUPTTERM 14
#define LCRZO_ERR_OKPROCESSABRUPTTERM_entxt "another process requested an abrupt termination of the process"
#define LCRZO_ERR_OKPROCESSABRUPTTERM_frtxt "un processus a termine ce processus de maniere abrupte"
#define LCRZO_ERR_OKROUTENOTETHER 15
#define LCRZO_ERR_OKROUTENOTETHER_entxt "Ethernet is not used to reach destination"
#define LCRZO_ERR_OKROUTENOTETHER_frtxt "Ethernet n'est pas utilise pour atteindre la destination"
#define LCRZO_ERR_00_END 15

/*en format error */
/*fr erreur de formatage */
#define LCRZO_ERR_03_BEGIN 300
#define LCRZO_ERR_FM 300
#define LCRZO_ERR_FM_entxt "format error family"
#define LCRZO_ERR_FM_frtxt "famille des erreurs de format"
#define LCRZO_ERR_FMETH 301
#define LCRZO_ERR_FMETH_entxt "the ethernet address hasn't the format 01:23:45:67:89:ab"
#define LCRZO_ERR_FMETH_frtxt "l'adresse Ethernet n'a pas le format 01:23:45:67:89:ab"
#define LCRZO_ERR_FMIP 302
#define LCRZO_ERR_FMIP_entxt "the IP address hasn't the format 1.2.3.4"
#define LCRZO_ERR_FMIP_frtxt "l'adresse IP n'a pas le format 1.2.3.4"
#define LCRZO_ERR_FMETHRANGE 303
#define LCRZO_ERR_FMETHRANGE_entxt "the ethernet range hasn't the format 'a:b:c:d:e:f-1:2:3:4:5:6', 'a:b:c:d:e:f/56', etc."
#define LCRZO_ERR_FMETHRANGE_frtxt "la plage ethernet n'a pas le format 'a:b:c:d:e:f-1:2:3:4:5:6', 'a:b:c:d:e:f/56', etc."
#define LCRZO_ERR_FMIPRANGE 304
#define LCRZO_ERR_FMIPRANGE_entxt "the IP range hasn't the format '1.2.3.4-5.6.7.8', '1.2.3.0/24', '1.2.3/24', '1.2.3.0%24', '1.2.3%24', '1.2.3.0/255.255.255.0', etc."
#define LCRZO_ERR_FMIPRANGE_frtxt "la plage ip n'a pas le format '1.2.3.4-5.6.7.8', '1.2.3.0/24', '1.2.3/24', '1.2.3.0%24', '1.2.3%24', '1.2.3.0/255.255.255.0', etc."
#define LCRZO_ERR_FMPORTRANGE 305
#define LCRZO_ERR_FMPORTRANGE_entxt "the port's range hasn't the format '[portinf]-[portsup]'"
#define LCRZO_ERR_FMPORTRANGE_frtxt "la plage de ports n'a pas le format '[portinf]-[portsup]'"
#define LCRZO_ERR_FMINTFMT 306
#define LCRZO_ERR_FMINTFMT_entxt "the format for the integer isn't '%[0+. -]{0,1}[0-9]{0,2}{0,1}[douxX]'"
#define LCRZO_ERR_FMINTFMT_frtxt "le format d'entier n'est pas '%[0+. -]{0,1}[0-9]{0,2}{0,1}[douxX]'"
#define LCRZO_ERR_FMREGEXP 307
#define LCRZO_ERR_FMREGEXP_entxt "only $1-$9 or $$ are allowed in a replacement string for a regular expression"
#define LCRZO_ERR_FMREGEXP_frtxt "seuls $1-$9 ou $$ sont autorises dans une chaine de remplacement d'expression reguliere"
#define LCRZO_ERR_FMMIXED 308
#define LCRZO_ERR_FMMIXED_entxt "the mixed string doesn't finish by '"
#define LCRZO_ERR_FMMIXED_frtxt "la chaine mixte ne se termine pas par '"
#define LCRZO_ERR_FMHEXACHAR 309
#define LCRZO_ERR_FMHEXACHAR_entxt "an hexa string must not contain a character different from A-Fa-f0-9"
#define LCRZO_ERR_FMHEXACHAR_frtxt "caractere autre que A-Fa-f0-9 trouve dans une chaine hexa"
#define LCRZO_ERR_FMHEXAODD 310
#define LCRZO_ERR_FMHEXAODD_entxt "the byte number in the hexa string is odd"
#define LCRZO_ERR_FMHEXAODD_frtxt "le nombre de quartets de la chaine hexa est impair"
#define LCRZO_ERR_FMBASE64CHAR 311
#define LCRZO_ERR_FMBASE64CHAR_entxt "all characters in a base64 must be in A-Za-z0-9+/="
#define LCRZO_ERR_FMBASE64CHAR_frtxt "un caractere n'est pas en base64 (A-Za-z0-9+/=)"
#define LCRZO_ERR_FMBASE64X4 312
#define LCRZO_ERR_FMBASE64X4_entxt "with base64, the byte number must be a multiple of 4"
#define LCRZO_ERR_FMBASE64X4_frtxt "en base64, le nb de caracteres doit etre multiple de 4"
#define LCRZO_ERR_FMNOTINT 313
#define LCRZO_ERR_FMNOTINT_entxt "the string is not an integer"
#define LCRZO_ERR_FMNOTINT_frtxt "la chaine texte ne represente pas un entier"
#define LCRZO_ERR_FMINTFMTL 314
#define LCRZO_ERR_FMINTFMTL_entxt "the format for the integer contains an 'l'"
#define LCRZO_ERR_FMINTFMTL_frtxt "le format d'entier contient un 'l'"
#define LCRZO_ERR_03_END 314

/*en position errors*/
/*fr erreurs de position */
#define LCRZO_ERR_04_BEGIN 400
#define LCRZO_ERR_PO 400
#define LCRZO_ERR_PO_entxt "position error family"
#define LCRZO_ERR_PO_frtxt "famille des erreurs de position"
#define LCRZO_ERR_POTOOLOW 401
#define LCRZO_ERR_POTOOLOW_entxt "the position is too low"
#define LCRZO_ERR_POTOOLOW_frtxt "la position est trop petite"
#define LCRZO_ERR_POTOOBIG 402
#define LCRZO_ERR_POTOOBIG_entxt "the position is too big"
#define LCRZO_ERR_POTOOBIG_frtxt "la position est trop grande"
#define LCRZO_ERR_PONOZERO 403
#define LCRZO_ERR_PONOZERO_entxt "the position 0 is invalid"
#define LCRZO_ERR_PONOZERO_frtxt "la position zero n'est pas valide"
#define LCRZO_ERR_POINFTOOLOW 404
#define LCRZO_ERR_POINFTOOLOW_entxt "the inferior position is too low"
#define LCRZO_ERR_POINFTOOLOW_frtxt "la position inferieure est trop petite"
#define LCRZO_ERR_POINFTOOBIG 405
#define LCRZO_ERR_POINFTOOBIG_entxt "the inferior position is too big"
#define LCRZO_ERR_POINFTOOBIG_frtxt "la position inferieure est trop grande"
#define LCRZO_ERR_POSUPTOOLOW 406
#define LCRZO_ERR_POSUPTOOLOW_entxt "the superior position is too low"
#define LCRZO_ERR_POSUPTOOLOW_frtxt "la position superieure est trop petite"
#define LCRZO_ERR_POSUPTOOBIG 407
#define LCRZO_ERR_POSUPTOOBIG_entxt "the superior position is too big"
#define LCRZO_ERR_POSUPTOOBIG_frtxt "la position superieure est trop grande"
#define LCRZO_ERR_POINFHIGHERSUP 408
#define LCRZO_ERR_POINFHIGHERSUP_entxt "the inferior position is higher than the superior position"
#define LCRZO_ERR_POINFHIGHERSUP_frtxt "la position inferieure est plus grande que la position superieure"
#define LCRZO_ERR_04_END 408

/*en generic parameters errors */
/*fr erreurs de parametres */
#define LCRZO_ERR_05_BEGIN 500
#define LCRZO_ERR_PA 500
#define LCRZO_ERR_PA_entxt "parameter error family"
#define LCRZO_ERR_PA_frtxt "famille des erreurs de parametre"
#define LCRZO_ERR_PATOOLOW 501
#define LCRZO_ERR_PATOOLOW_entxt "the parameter is too low"
#define LCRZO_ERR_PATOOLOW_frtxt "le parametre est trop petit"
#define LCRZO_ERR_PATOOBIG 502
#define LCRZO_ERR_PATOOBIG_entxt "the parameter is too big"
#define LCRZO_ERR_PATOOBIG_frtxt "le parametre est trop grand"
#define LCRZO_ERR_PAINFTOOLOW 503
#define LCRZO_ERR_PAINFTOOLOW_entxt "the inferior parameter is too low"
#define LCRZO_ERR_PAINFTOOLOW_frtxt "le parametre inferieur est trop petit"
#define LCRZO_ERR_PAINFTOOBIG 504
#define LCRZO_ERR_PAINFTOOBIG_entxt "the inferior parameter is too big"
#define LCRZO_ERR_PAINFTOOBIG_frtxt "le parametre inferieur est trop grand"
#define LCRZO_ERR_PASUPTOOLOW 505
#define LCRZO_ERR_PASUPTOOLOW_entxt "the superior parameter is too low"
#define LCRZO_ERR_PASUPTOOLOW_frtxt "le parametre superieur est trop petit"
#define LCRZO_ERR_PASUPTOOBIG 506
#define LCRZO_ERR_PASUPTOOBIG_entxt "the superior parameter is too big"
#define LCRZO_ERR_PASUPTOOBIG_frtxt "le parametre superieur est trop grand"
#define LCRZO_ERR_PAINFHIGHERSUP 507
#define LCRZO_ERR_PAINFHIGHERSUP_entxt "the inferior parameter is higher than the superior parameter"
#define LCRZO_ERR_PAINFHIGHERSUP_frtxt "le parametre inferieur est plus grand que le parametre superieur"
#define LCRZO_ERR_PAOVERFLOW 508
#define LCRZO_ERR_PAOVERFLOW_entxt "an overflow was detected"
#define LCRZO_ERR_PAOVERFLOW_frtxt "une tentative d'overflow a ete detectee"
#define LCRZO_ERR_PADEFAULTNOTINRANGE 509
#define LCRZO_ERR_PADEFAULTNOTINRANGE_entxt "the default value is not in the range"
#define LCRZO_ERR_PADEFAULTNOTINRANGE_frtxt "la valeur par defaut est hors intervalle"
#define LCRZO_ERR_PANULLPTR 510
#define LCRZO_ERR_PANULLPTR_entxt "a NULL pointer is not allowed"
#define LCRZO_ERR_PANULLPTR_frtxt "le pointeur ne doit pas etre NULL"
/* this error is obsolete : */
#define LCRZO_ERR_PABOOLNOT01 511
#define LCRZO_ERR_PABOOLNOT01_entxt "a boolean must be 0 or 1"
#define LCRZO_ERR_PABOOLNOT01_frtxt "un booleen ne peut valoir que 0 ou 1"
#define LCRZO_ERR_PADATACURSUPMAX 512
#define LCRZO_ERR_PADATACURSUPMAX_entxt "the current data size is greater than the max size"
#define LCRZO_ERR_PADATACURSUPMAX_frtxt "la taille courante des donnees est superieure a sa taille maximale"
#define LCRZO_ERR_PAUNKNOWNTYPE 513
#define LCRZO_ERR_PAUNKNOWNTYPE_entxt "specified type is unknown"
#define LCRZO_ERR_PAUNKNOWNTYPE_frtxt "le type specifie est inconnu"
#define LCRZO_ERR_PANULLPTRSIZE 514
#define LCRZO_ERR_PANULLPTRSIZE_entxt "pointer of array is NULL, but array'size isn't zero"
#define LCRZO_ERR_PANULLPTRSIZE_frtxt "le pointeur du tableau est NULL, mais la taille du tableau n'est pas zero"
#define LCRZO_ERR_05_END 514

/*en module specific errors */
/*fr erreurs specifiques a certains modules de lcrzo */
#define LCRZO_ERR_06_BEGIN 600
#define LCRZO_ERR_SP 600
#define LCRZO_ERR_SP_entxt "specific parameter error family"
#define LCRZO_ERR_SP_frtxt "famille des erreurs de parametre specifique"
#define LCRZO_ERR_SPOPTNOTX4 601
#define LCRZO_ERR_SPOPTNOTX4_entxt "the option size is not a multiple of 4"
#define LCRZO_ERR_SPOPTNOTX4_frtxt "la taille des options n'est pas un multiple de 4"
#define LCRZO_ERR_SPOPTMAX10 602
#define LCRZO_ERR_SPOPTMAX10_entxt "you cannot have more than 10 lines of options"
#define LCRZO_ERR_SPOPTMAX10_frtxt "il ne peut y avoir plus de 10 lignes d'options"
#define LCRZO_ERR_SPTOOBIGFORHDRL 603
#define LCRZO_ERR_SPTOOBIGFORHDRL_entxt "a parameter in the logical header is too big to go in the physical header"
#define LCRZO_ERR_SPTOOBIGFORHDRL_frtxt "un parametre de l'entete logique est trop grand pour entrer dans l'entete physique"
#define LCRZO_ERR_SPUNKNOWNDEVICE 604
#define LCRZO_ERR_SPUNKNOWNDEVICE_entxt "unknown device"
#define LCRZO_ERR_SPUNKNOWNDEVICE_frtxt "device inconnu"
#define LCRZO_ERR_SPPATHROOTDOTDOT 605
#define LCRZO_ERR_SPPATHROOTDOTDOT_entxt "too many .. in the path : go up /"
#define LCRZO_ERR_SPPATHROOTDOTDOT_frtxt "trop de .. dans le chemin et remonte au dessus de /"
#define LCRZO_ERR_SPRECORDPRINTTYPE 606
#define LCRZO_ERR_SPRECORDPRINTTYPE_entxt "the lcrzo_printtype cannot be read by a record"
#define LCRZO_ERR_SPRECORDPRINTTYPE_frtxt "le lcrzo_printtype ne peut pas etre relu par un record"
#define LCRZO_ERR_SPTIMESECOVER 607
#define LCRZO_ERR_SPTIMESECOVER_entxt "time is too big to be stored in seconds"
#define LCRZO_ERR_SPTIMESECOVER_frtxt "time est trop grand pour etre stocke en secondes"
#define LCRZO_ERR_SPTIMEMSECOVER 608
#define LCRZO_ERR_SPTIMEMSECOVER_entxt "time is too big to be stored in milliseconds"
#define LCRZO_ERR_SPTIMEMSECOVER_frtxt "time est trop grand pour etre stocke en millisecondes"
#define LCRZO_ERR_SPTIMEUSECOVER 609
#define LCRZO_ERR_SPTIMEUSECOVER_entxt "time is too big to be stored in microseconds"
#define LCRZO_ERR_SPTIMEUSECOVER_frtxt "time est trop grand pour etre stocke en microsecondes"
#define LCRZO_ERR_SPTIMETIMEOVER 610
#define LCRZO_ERR_SPTIMETIMEOVER_entxt "time is too big"
#define LCRZO_ERR_SPTIMETIMEOVER_frtxt "le temps est trop grand"
#define LCRZO_ERR_SPTIMEDIFFNEG 611
#define LCRZO_ERR_SPTIMEDIFFNEG_entxt "time difference is negative"
#define LCRZO_ERR_SPTIMEDIFFNEG_frtxt "la difference de temps est negative"
#define LCRZO_ERR_SPREGBADTYPE 612
#define LCRZO_ERR_SPREGBADTYPE_entxt "invalid key type in registry"
#define LCRZO_ERR_SPREGBADTYPE_frtxt "type de cle invalide dans la registry"
#define LCRZO_ERR_SPSNMPDLLBADTYPE 613
#define LCRZO_ERR_SPSNMPDLLBADTYPE_entxt "invalid snmp type for this MIB OID"
#define LCRZO_ERR_SPSNMPDLLBADTYPE_frtxt "type snmp invalide pour cet OID MIB"
#define LCRZO_ERR_SPLISTFULL 614
#define LCRZO_ERR_SPLISTFULL_entxt "the list cannot have more than 0x7FFFFFFF elements"
#define LCRZO_ERR_SPLISTFULL_frtxt "la liste est pleine : maxi 0x7FFFFFF elements"
#define LCRZO_ERR_SPFILESECURITY 615
#define LCRZO_ERR_SPFILESECURITY_entxt "security exception on file opening"
#define LCRZO_ERR_SPFILESECURITY_frtxt "erreur lors de l'ouverture du fichier"
#define LCRZO_ERR_SPSOCKTCPNOSA 616
#define LCRZO_ERR_SPSOCKTCPNOSA_entxt "we didn't received any syn ack"
#define LCRZO_ERR_SPSOCKTCPNOSA_frtxt "on n'a pas recu de syn-ack"
#define LCRZO_ERR_SPSOCKTCPRST 617
#define LCRZO_ERR_SPSOCKTCPRST_entxt "we received a reset during the handshake"
#define LCRZO_ERR_SPSOCKTCPRST_frtxt "on a recu un reset pendant le handshake"
#define LCRZO_ERR_SPFILE2G 618
#define LCRZO_ERR_SPFILE2G_entxt "lcrzo cannot deal with files > 2G bytes"
#define LCRZO_ERR_SPFILE2G_frtxt "lcrzo ne supporte pas les fichiers de plus de 2G octets"
#define LCRZO_ERR_SPDEVNOTETHER 619
#define LCRZO_ERR_SPDEVNOTETHER_entxt "device does not have Ethernet type"
#define LCRZO_ERR_SPDEVNOTETHER_frtxt "le device n'est pas de type Ethernet"
#define LCRZO_ERR_SPDEVNOETHERSPOOF 620
#define LCRZO_ERR_SPDEVNOETHERSPOOF_entxt "device does not support Ethernet spoof"
#define LCRZO_ERR_SPDEVNOETHERSPOOF_frtxt "le device ne supporte pas le spoof Ethernet"
#define LCRZO_ERR_06_END 620

/*en logic error */
/*fr erreurs de logique */
#define LCRZO_ERR_07_BEGIN 700
#define LCRZO_ERR_LO 700
#define LCRZO_ERR_LO_entxt "logic error family"
#define LCRZO_ERR_LO_frtxt "famille des erreurs logique"
#define LCRZO_ERR_LOUNKNOWNERROR 701
#define LCRZO_ERR_LOUNKNOWNERROR_entxt "error unknown by lcrzo"
#define LCRZO_ERR_LOUNKNOWNERROR_frtxt "erreur inconnue par lcrzo"
#define LCRZO_ERR_LOUDPSERMULTINOWRITE 702
#define LCRZO_ERR_LOUDPSERMULTINOWRITE_entxt "it is not possible to write with an udp multiclient server (obsolete)"
#define LCRZO_ERR_LOUDPSERMULTINOWRITE_frtxt "les serveurs UDP multiclients ne permettent pas d'ecrire (obsolete)"
#define LCRZO_ERR_LOUDPSERREADBEFWRITE 703
#define LCRZO_ERR_LOUDPSERREADBEFWRITE_entxt "it is not possible to write before reading on a udp server"
#define LCRZO_ERR_LOUDPSERREADBEFWRITE_frtxt "sur un serveur UDP, il faut lire avant de pouvoir ecrire"
#define LCRZO_ERR_LONOTOPEN 704
#define LCRZO_ERR_LONOTOPEN_entxt "not open"
#define LCRZO_ERR_LONOTOPEN_frtxt "non ouvert"
#define LCRZO_ERR_LONOTOPENFORREADING 705
#define LCRZO_ERR_LONOTOPENFORREADING_entxt "not open for reading"
#define LCRZO_ERR_LONOTOPENFORREADING_frtxt "non ouvert en lecture"
#define LCRZO_ERR_LONOTOPENFORWRITING 706
#define LCRZO_ERR_LONOTOPENFORWRITING_entxt "not open for writing"
#define LCRZO_ERR_LONOTOPENFORWRITING_frtxt "non ouvert en ecriture"
#define LCRZO_ERR_LOALREADYCLOSED 707
#define LCRZO_ERR_LOALREADYCLOSED_entxt "already closed"
#define LCRZO_ERR_LOALREADYCLOSED_frtxt "deja ferme"
#define LCRZO_ERR_LOWAITLISTEMPTY 708
#define LCRZO_ERR_LOWAITLISTEMPTY_entxt "waiting list is empty"
#define LCRZO_ERR_LOWAITLISTEMPTY_frtxt "la liste d'attente est vide"
#define LCRZO_ERR_LOIPCSIDENOTSET 709
#define LCRZO_ERR_LOIPCSIDENOTSET_entxt "side (currentprocessisside) must be set before using an lcrzo_ipc"
#define LCRZO_ERR_LOIPCSIDENOTSET_frtxt "le cote (currentprocessisside) doit etre affecte avant d'utiliser un lcrzo_ipc"
#define LCRZO_ERR_LOFREEUNALLOC 710
#define LCRZO_ERR_LOFREEUNALLOC_entxt "free of unallocated memory"
#define LCRZO_ERR_LOFREEUNALLOC_frtxt "free d'une zone memoire non allouee"
#define LCRZO_ERR_LOMEMCORRUPT 711
#define LCRZO_ERR_LOMEMCORRUPT_entxt "memory corruption"
#define LCRZO_ERR_LOMEMCORRUPT_frtxt "corruption de memoire"
#define LCRZO_ERR_LOMEMDBLEFREE 712
#define LCRZO_ERR_LOMEMDBLEFREE_entxt "double free"
#define LCRZO_ERR_LOMEMDBLEFREE_frtxt "double free"
#define LCRZO_ERR_07_END 712

/*en internal errors */
/*fr erreurs internes */
#define LCRZO_ERR_08_BEGIN 800
#define LCRZO_ERR_IE 800
#define LCRZO_ERR_IE_entxt "internal error family"
#define LCRZO_ERR_IE_frtxt "famille des erreurs internes"
#define LCRZO_ERR_IEUNIMPLEMENTED 801
#define LCRZO_ERR_IEUNIMPLEMENTED_entxt "unimplemented function or parameter"
#define LCRZO_ERR_IEUNIMPLEMENTED_frtxt "fonction ou type d'appel non implemente"
#define LCRZO_ERR_IEINTERNALERROR 802
#define LCRZO_ERR_IEINTERNALERROR_entxt "internal error : contact Laurent"
#define LCRZO_ERR_IEINTERNALERROR_frtxt "erreur interne : contacter Laurent"
#define LCRZO_ERR_IEBADENDIAN 803
#define LCRZO_ERR_IEBADENDIAN_entxt "endianness error"
#define LCRZO_ERR_IEBADENDIAN_frtxt "erreur d'endianness"
#define LCRZO_ERR_IEBADSIZEOF 804
#define LCRZO_ERR_IEBADSIZEOF_entxt "incorrect sizeof for lcrzo_... type"
#define LCRZO_ERR_IEBADSIZEOF_frtxt "le sizeof des types lcrzo_... est incorrect"
#define LCRZO_ERR_IEOKKO 805
#define LCRZO_ERR_IEOKKO_entxt "LCRZO_ERR_OK is returned by the function, but this should not append"
#define LCRZO_ERR_IEOKKO_frtxt "la fonction a retourne LCRZO_ERR_OK, mais ce n'etait pas attendu"
#define LCRZO_ERR_IEIPCBADELEMSIZE 806
#define LCRZO_ERR_IEIPCBADELEMSIZE_entxt "the size of the elem in the IPC is not coherent with its type"
#define LCRZO_ERR_IEIPCBADELEMSIZE_frtxt "la taille des donnees dans l'ipc est incoherente avec son type"
#define LCRZO_ERR_08_END 806

/*en reserved */
/*fr reserve */
#define LCRZO_ERR_09_BEGIN 900
#define LCRZO_ERR_09_END 900

/*en system functions errors*/
/*fr erreurs de fonctions systeme */
#define LCRZO_ERR_10_BEGIN 1000
#define LCRZO_ERR_FU 1000
#define LCRZO_ERR_FU_entxt "system function error family"
#define LCRZO_ERR_FU_frtxt "famille des erreurs de fonctions systeme"
#define LCRZO_ERR_FUSENDTO 1001
#define LCRZO_ERR_FUSENDTO_entxt "error in sendto()"
#define LCRZO_ERR_FUSENDTO_frtxt "erreur lors de l'appel a sendto()"
#define LCRZO_ERR_FUPCAPOPEN 1002
#define LCRZO_ERR_FUPCAPOPEN_entxt "error in pcap_open_live()"
#define LCRZO_ERR_FUPCAPOPEN_frtxt "erreur lors de l'appel pcap_open_live()"
#define LCRZO_ERR_FUCONNECT 1003
#define LCRZO_ERR_FUCONNECT_entxt "error in connect()"
#define LCRZO_ERR_FUCONNECT_frtxt "erreur lors de l'appel a connect()"
#define LCRZO_ERR_FUREAD 1004
#define LCRZO_ERR_FUREAD_entxt "error in read()"
#define LCRZO_ERR_FUREAD_frtxt "erreur lors de l'appel a read()"
#define LCRZO_ERR_FUWRITE 1005
#define LCRZO_ERR_FUWRITE_entxt "error in write()"
#define LCRZO_ERR_FUWRITE_frtxt "erreur lors de l'appel a write()"
#define LCRZO_ERR_FUREGCOMP 1006
#define LCRZO_ERR_FUREGCOMP_entxt "error in regcomp()"
#define LCRZO_ERR_FUREGCOMP_frtxt "erreur lors de l'appel regcomp()"
#define LCRZO_ERR_FUCLOSE 1007
#define LCRZO_ERR_FUCLOSE_entxt "error in close()"
#define LCRZO_ERR_FUCLOSE_frtxt "erreur lors de l'appel a close()"
#define LCRZO_ERR_FULISTEN 1008
#define LCRZO_ERR_FULISTEN_entxt "error in listen()"
#define LCRZO_ERR_FULISTEN_frtxt "erreur lors de l'appel a listen()"
#define LCRZO_ERR_FUACCEPT 1009
#define LCRZO_ERR_FUACCEPT_entxt "error in accept()"
#define LCRZO_ERR_FUACCEPT_frtxt "erreur lors de l'appel a accept()"
#define LCRZO_ERR_FUPCAPLOOKUPDEV 1010
#define LCRZO_ERR_FUPCAPLOOKUPDEV_entxt "error in pcap_lookupdev()"
#define LCRZO_ERR_FUPCAPLOOKUPDEV_frtxt "erreur lors de l'appel pcap_lookupdev()"
#define LCRZO_ERR_FUPCAPLOOKUPNET 1011
#define LCRZO_ERR_FUPCAPLOOKUPNET_entxt "error in pcap_lookupnet()"
#define LCRZO_ERR_FUPCAPLOOKUPNET_frtxt "erreur lors de l'appel pcap_lookupnet()"
#define LCRZO_ERR_FUPCAPCOMPILE 1012
#define LCRZO_ERR_FUPCAPCOMPILE_entxt "error in pcap_compile()"
#define LCRZO_ERR_FUPCAPCOMPILE_frtxt "erreur lors de l'appel pcap_compile()"
#define LCRZO_ERR_FUPCAPSETFILTER 1013
#define LCRZO_ERR_FUPCAPSETFILTER_entxt "error in pcap_setfilter()"
#define LCRZO_ERR_FUPCAPSETFILTER_frtxt "erreur lors de l'appel pcap_setfilter()"
#define LCRZO_ERR_FUFOPEN 1014
#define LCRZO_ERR_FUFOPEN_entxt "error in fopen()"
#define LCRZO_ERR_FUFOPEN_frtxt "erreur lors de l'appel fopen()"
#define LCRZO_ERR_FUFCLOSE 1015
#define LCRZO_ERR_FUFCLOSE_entxt "error in fclose()"
#define LCRZO_ERR_FUFCLOSE_frtxt "erreur lors de l'appel fclose()"
#define LCRZO_ERR_FUSYSCTL 1016
#define LCRZO_ERR_FUSYSCTL_entxt "error in sysctl()"
#define LCRZO_ERR_FUSYSCTL_frtxt "erreur lors de l'appel sysctl()"
#define LCRZO_ERR_FUMALLOC 1017
#define LCRZO_ERR_FUMALLOC_entxt "error in malloc()"
#define LCRZO_ERR_FUMALLOC_frtxt "erreur lors de l'appel malloc()"
#define LCRZO_ERR_FUTCGETATTR 1018
#define LCRZO_ERR_FUTCGETATTR_entxt "error in tcgetattr()"
#define LCRZO_ERR_FUTCGETATTR_frtxt "erreur lors de l'appel tcgetattr()"
#define LCRZO_ERR_FUTCSETATTR 1019
#define LCRZO_ERR_FUTCSETATTR_entxt "error in tcsetattr()"
#define LCRZO_ERR_FUTCSETATTR_frtxt "erreur lors de l'appel tcsetattr()"
#define LCRZO_ERR_FUFSEEK 1020
#define LCRZO_ERR_FUFSEEK_entxt "error in fseek()"
#define LCRZO_ERR_FUFSEEK_frtxt "erreur lors de l'appel fseek()"
#define LCRZO_ERR_FUIOCTL 1021
#define LCRZO_ERR_FUIOCTL_entxt "error in ioctl()"
#define LCRZO_ERR_FUIOCTL_frtxt "erreur lors de l'appel ioctl()"
#define LCRZO_ERR_FUGETHOSTNAME 1022
#define LCRZO_ERR_FUGETHOSTNAME_entxt "error in gethostname()"
#define LCRZO_ERR_FUGETHOSTNAME_frtxt "erreur lors de l'appel gethostname()"
#define LCRZO_ERR_FUKILL 1023
#define LCRZO_ERR_FUKILL_entxt "error in kill()"
#define LCRZO_ERR_FUKILL_frtxt "erreur lors de l'appel kill()"
#define LCRZO_ERR_FUWAITPID 1024
#define LCRZO_ERR_FUWAITPID_entxt "error in waitpid()"
#define LCRZO_ERR_FUWAITPID_frtxt "erreur lors de l'appel waitpid()"
#define LCRZO_ERR_FUPIPE 1025
#define LCRZO_ERR_FUPIPE_entxt "error in pipe()"
#define LCRZO_ERR_FUPIPE_frtxt "erreur lors de l'appel pipe()"
#define LCRZO_ERR_FUFORK 1026
#define LCRZO_ERR_FUFORK_entxt "error in fork()"
#define LCRZO_ERR_FUFORK_frtxt "erreur lors de l'appel fork()"
#define LCRZO_ERR_FUFCNTL 1027
#define LCRZO_ERR_FUFCNTL_entxt "error in fcntl()"
#define LCRZO_ERR_FUFCNTL_frtxt "erreur lors de l'appel fcntl()"
#define LCRZO_ERR_FUPUTMSG 1028
#define LCRZO_ERR_FUPUTMSG_entxt "error in putmsg()"
#define LCRZO_ERR_FUPUTMSG_frtxt "erreur lors de l'appel putmsg()"
#define LCRZO_ERR_FUGETMSG 1029
#define LCRZO_ERR_FUGETMSG_entxt "error in getmsg()"
#define LCRZO_ERR_FUGETMSG_frtxt "erreur lors de l'appel getmsg()"
#define LCRZO_ERR_FULIBNETOPENLINKINT 1030
#define LCRZO_ERR_FULIBNETOPENLINKINT_entxt "error in libnet_open_link_interface()"
#define LCRZO_ERR_FULIBNETOPENLINKINT_frtxt "erreur lors de l'appel libnet_open_link_interface()"
#define LCRZO_ERR_FULIBNETGETHWADDR 1031
#define LCRZO_ERR_FULIBNETGETHWADDR_entxt "error in libnet_get_hwaddr()"
#define LCRZO_ERR_FULIBNETGETHWADDR_frtxt "erreur lors de l'appel libnet_get_hwaddr()"
#define LCRZO_ERR_FULIBNETCLOSELINKINT 1032
#define LCRZO_ERR_FULIBNETCLOSELINKINT_entxt "error in libnet_close_link_interface()"
#define LCRZO_ERR_FULIBNETCLOSELINKINT_frtxt "erreur lors de l'appel libnet_close_link_interface()"
#define LCRZO_ERR_FULIBNETOPENRAWSOCK 1033
#define LCRZO_ERR_FULIBNETOPENRAWSOCK_entxt "error in libnet_open_raw_sock()"
#define LCRZO_ERR_FULIBNETOPENRAWSOCK_frtxt "erreur lors de l'appel libnet_open_raw_sock()"
#define LCRZO_ERR_FULIBNETWRITEIP 1034
#define LCRZO_ERR_FULIBNETWRITEIP_entxt "error in libnet_write_ip()"
#define LCRZO_ERR_FULIBNETWRITEIP_frtxt "erreur lors de l'appel libnet_write_ip()"
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK 1035
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK_entxt "error in libnet_close_raw_sock()"
#define LCRZO_ERR_FULIBNETCLOSERAWSOCK_frtxt "erreur lors de l'appel libnet_close_raw_sock()"
#define LCRZO_ERR_FULIBNETWRITELL 1036
#define LCRZO_ERR_FULIBNETWRITELL_entxt "error in libnet_write_link_layer()"
#define LCRZO_ERR_FULIBNETWRITELL_frtxt "erreur lors de l'appel libnet_write_link_layer()"
#define LCRZO_ERR_FUSETSOCKOPT 1037
#define LCRZO_ERR_FUSETSOCKOPT_entxt "error in setsockopt()"
#define LCRZO_ERR_FUSETSOCKOPT_frtxt "erreur lors de l'appel setsockopt()"
#define LCRZO_ERR_FUBIND 1038
#define LCRZO_ERR_FUBIND_entxt "error in bind()"
#define LCRZO_ERR_FUBIND_frtxt "erreur lors de l'appel bind()"
#define LCRZO_ERR_FUGETSOCKNAME 1039
#define LCRZO_ERR_FUGETSOCKNAME_entxt "error in getsockname()"
#define LCRZO_ERR_FUGETSOCKNAME_frtxt "erreur lors de l'appel getsockname()"
#define LCRZO_ERR_FUGETPEERNAME 1040
#define LCRZO_ERR_FUGETPEERNAME_entxt "error in getpeername()"
#define LCRZO_ERR_FUGETPEERNAME_frtxt "erreur lors de l'appel getpeername()"
#define LCRZO_ERR_FURECVFROM 1041
#define LCRZO_ERR_FURECVFROM_entxt "error in recvfrom()"
#define LCRZO_ERR_FURECVFROM_frtxt "erreur lors de l'appel recvfrom()"
#define LCRZO_ERR_FUGETTIMEOFDAY 1042
#define LCRZO_ERR_FUGETTIMEOFDAY_entxt "error in gettimeofday()"
#define LCRZO_ERR_FUGETTIMEOFDAY_frtxt "erreur lors de l'appel gettimeofday()"
#define LCRZO_ERR_FUOPEN 1043
#define LCRZO_ERR_FUOPEN_entxt "error in open()"
#define LCRZO_ERR_FUOPEN_frtxt "erreur lors de l'appel open()"
#define LCRZO_ERR_FULSTAT 1044
#define LCRZO_ERR_FULSTAT_entxt "error in lstat()"
#define LCRZO_ERR_FULSTAT_frtxt "erreur lors de l'appel lstat()"
#define LCRZO_ERR_FUFSTAT 1045
#define LCRZO_ERR_FUFSTAT_entxt "error in fstat()"
#define LCRZO_ERR_FUFSTAT_frtxt "erreur lors de l'appel fstat()"
#define LCRZO_ERR_FUSTAT 1046
#define LCRZO_ERR_FUSTAT_entxt "error in stat()"
#define LCRZO_ERR_FUSTAT_frtxt "erreur lors de l'appel stat()"
#define LCRZO_ERR_FUFTRUNCATE 1047
#define LCRZO_ERR_FUFTRUNCATE_entxt "error in ftruncate()"
#define LCRZO_ERR_FUFTRUNCATE_frtxt "erreur lors de l'appel ftruncate()"
#define LCRZO_ERR_FUSETEUID 1048
#define LCRZO_ERR_FUSETEUID_entxt "error in seteuid()"
#define LCRZO_ERR_FUSETEUID_frtxt "erreur lors de l'appel seteuid()"
#define LCRZO_ERR_FUSETEGID 1049
#define LCRZO_ERR_FUSETEGID_entxt "error in setguid()"
#define LCRZO_ERR_FUSETEGID_frtxt "erreur lors de l'appel setguid()"
#define LCRZO_ERR_FUFDOPEN 1050
#define LCRZO_ERR_FUFDOPEN_entxt "error in fdopen()"
#define LCRZO_ERR_FUFDOPEN_frtxt "erreur lors de l'appel fdopen()"
#define LCRZO_ERR_FUREALLOC 1051
#define LCRZO_ERR_FUREALLOC_entxt "error in realloc()"
#define LCRZO_ERR_FUREALLOC_frtxt "erreur lors de l'appel realloc()"
#define LCRZO_ERR_FUPOPEN 1052
#define LCRZO_ERR_FUPOPEN_entxt "error in popen()"
#define LCRZO_ERR_FUPOPEN_frtxt "erreur lors de l'appel popen()"
#define LCRZO_ERR_FUPCLOSE 1053
#define LCRZO_ERR_FUPCLOSE_entxt "error in pclose()"
#define LCRZO_ERR_FUPCLOSE_frtxt "erreur lors de l'appel pclose()"
#define LCRZO_ERR_FUUNLINK 1054
#define LCRZO_ERR_FUUNLINK_entxt "error in unlink()"
#define LCRZO_ERR_FUUNLINK_frtxt "erreur lors de l'appel unlink()"
#define LCRZO_ERR_FUFFLUSH 1055
#define LCRZO_ERR_FUFFLUSH_entxt "error in fflush()"
#define LCRZO_ERR_FUFFLUSH_frtxt "erreur lors de l'appel fflush()"
#define LCRZO_ERR_FULSEEK 1056
#define LCRZO_ERR_FULSEEK_entxt "error in lseek()"
#define LCRZO_ERR_FULSEEK_frtxt "erreur lors de l'appel lseek()"
#define LCRZO_ERR_FUFSYNC 1057
#define LCRZO_ERR_FUFSYNC_entxt "error in fsync()"
#define LCRZO_ERR_FUFSYNC_frtxt "erreur lors de l'appel fsync()"
#define LCRZO_ERR_FUFGETS 1058
#define LCRZO_ERR_FUFGETS_entxt "error in fgets()"
#define LCRZO_ERR_FUFGETS_frtxt "erreur lors de l'appel fgets()"
#define LCRZO_ERR_FUFCHMOD 1059
#define LCRZO_ERR_FUFCHMOD_entxt "error in fchmod()"
#define LCRZO_ERR_FUFCHMOD_frtxt "erreur lors de l'appel fchmod()"
#define LCRZO_ERR_FUFCHOWN 1060
#define LCRZO_ERR_FUFCHOWN_entxt "error in fchown()"
#define LCRZO_ERR_FUFCHOWN_frtxt "erreur lors de l'appel fchown()"
#define LCRZO_ERR_FUMKDIR 1061
#define LCRZO_ERR_FUMKDIR_entxt "error in mkdir()"
#define LCRZO_ERR_FUMKDIR_frtxt "erreur lors de l'appel mkdir()"
#define LCRZO_ERR_FURENAME 1062
#define LCRZO_ERR_FURENAME_entxt "error in rename()"
#define LCRZO_ERR_FURENAME_frtxt "erreur lors de l'appel rename()"
#define LCRZO_ERR_FURMDIR 1063
#define LCRZO_ERR_FURMDIR_entxt "error in rmdir()"
#define LCRZO_ERR_FURMDIR_frtxt "erreur lors de l'appel rmdir()"
#define LCRZO_ERR_FUOPENDIR 1064
#define LCRZO_ERR_FUOPENDIR_entxt "error in opendir()"
#define LCRZO_ERR_FUOPENDIR_frtxt "erreur lors de l'appel opendir()"
#define LCRZO_ERR_FUSELECT 1065
#define LCRZO_ERR_FUSELECT_entxt "error in select()"
#define LCRZO_ERR_FUSELECT_frtxt "erreur lors de l'appel select()"
#define LCRZO_ERR_FUPCAPOPENOFFLINE 1066
#define LCRZO_ERR_FUPCAPOPENOFFLINE_entxt "error in pcap_open_offline()"
#define LCRZO_ERR_FUPCAPOPENOFFLINE_frtxt "erreur lors de l'appel pcap_open_offline()"
#define LCRZO_ERR_FUPCAPOPENDEAD 1067
#define LCRZO_ERR_FUPCAPOPENDEAD_entxt "error in pcap_open_dead()"
#define LCRZO_ERR_FUPCAPOPENDEAD_frtxt "erreur lors de l'appel pcap_open_dead()"
#define LCRZO_ERR_FUPCAPDUMPOPEN 1068
#define LCRZO_ERR_FUPCAPDUMPOPEN_entxt "error in pcap_dump_open()"
#define LCRZO_ERR_FUPCAPDUMPOPEN_frtxt "erreur lors de l'appel pcap_dump_open()"
#define LCRZO_ERR_FURAISE 1069
#define LCRZO_ERR_FURAISE_entxt "error in raise()"
#define LCRZO_ERR_FURAISE_frtxt "erreur lors de l'appel raise()"
#define LCRZO_ERR_FUPOLL 1070
#define LCRZO_ERR_FUPOLL_entxt "error in poll()"
#define LCRZO_ERR_FUPOLL_frtxt "erreur lors de l'appel poll()"
#define LCRZO_ERR_FUCREATETHREAD 1071
#define LCRZO_ERR_FUCREATETHREAD_entxt "error in CreateThread()"
#define LCRZO_ERR_FUCREATETHREAD_frtxt "erreur lors de l'appel CreateThread()"
#define LCRZO_ERR_FUGETEXITCODETHREAD 1072
#define LCRZO_ERR_FUGETEXITCODETHREAD_entxt "error in GetExitCodeThread()"
#define LCRZO_ERR_FUGETEXITCODETHREAD_frtxt "erreur lors de l'appel GetExitCodeThread()"
#define LCRZO_ERR_FUCLOSEHANDLE 1073
#define LCRZO_ERR_FUCLOSEHANDLE_entxt "error in CloseHandle()"
#define LCRZO_ERR_FUCLOSEHANDLE_frtxt "erreur lors de l'appel CloseHandle()"
#define LCRZO_ERR_FUWAITFORSINGLEOBJECT 1074
#define LCRZO_ERR_FUWAITFORSINGLEOBJECT_entxt "error in WaitForSingleObject()"
#define LCRZO_ERR_FUWAITFORSINGLEOBJECT_frtxt "erreur lors de l'appel WaitForSingleObject()"
#define LCRZO_ERR_FUTERMINATETHREAD 1075
#define LCRZO_ERR_FUTERMINATETHREAD_entxt "error in TerminateThread()"
#define LCRZO_ERR_FUTERMINATETHREAD_frtxt "erreur lors de l'appel TerminateThread()"
#define LCRZO_ERR_FUDUPLICATEHANDLE 1076
#define LCRZO_ERR_FUDUPLICATEHANDLE_entxt "error in DuplicateHandle()"
#define LCRZO_ERR_FUDUPLICATEHANDLE_frtxt "erreur lors de l'appel DuplicateHandle()"
#define LCRZO_ERR_FUREGQUERYVALUEEX 1077
#define LCRZO_ERR_FUREGQUERYVALUEEX_entxt "error in RegQueryValueEx()"
#define LCRZO_ERR_FUREGQUERYVALUEEX_frtxt "erreur lors de l'appel RegQueryValueEx()"
#define LCRZO_ERR_FUREGOPENKEYEX 1078
#define LCRZO_ERR_FUREGOPENKEYEX_entxt "error in RegOpenKeyEx()"
#define LCRZO_ERR_FUREGOPENKEYEX_frtxt "erreur lors de l'appel RegOpenKeyEx()"
#define LCRZO_ERR_FUREGCLOSEKEY 1079
#define LCRZO_ERR_FUREGCLOSEKEY_entxt "error in RegCloseEx()"
#define LCRZO_ERR_FUREGCLOSEKEY_frtxt "erreur lors de l'appel RegCloseEx()"
#define LCRZO_ERR_FULOADLIBRARY 1080
#define LCRZO_ERR_FULOADLIBRARY_entxt "error in LoadLibrary()"
#define LCRZO_ERR_FULOADLIBRARY_frtxt "erreur lors de l'appel LoadLibrary()"
#define LCRZO_ERR_FUGETPROCADDRESS 1081
#define LCRZO_ERR_FUGETPROCADDRESS_entxt "error in GetProcAddress()"
#define LCRZO_ERR_FUGETPROCADDRESS_frtxt "erreur lors de l'appel GetProcAddress()"
#define LCRZO_ERR_FUSNMPEXTENSIONINIT 1082
#define LCRZO_ERR_FUSNMPEXTENSIONINIT_entxt "error in SnmpExtensionInit()"
#define LCRZO_ERR_FUSNMPEXTENSIONINIT_frtxt "erreur lors de l'appel SnmpExtensionInit()"
#define LCRZO_ERR_FUFREELIBRARY 1083
#define LCRZO_ERR_FUFREELIBRARY_entxt "error in FreeLibrary()"
#define LCRZO_ERR_FUFREELIBRARY_frtxt "erreur lors de l'appel FreeLibrary()"
#define LCRZO_ERR_FUSNMPEXTENSIONQUERY 1084
#define LCRZO_ERR_FUSNMPEXTENSIONQUERY_entxt "error in SnmpExtensionQuery()"
#define LCRZO_ERR_FUSNMPEXTENSIONQUERY_frtxt "erreur lors de l'appel SnmpExtensionQuery()"
#define LCRZO_ERR_FUGLOBALALLOC 1085
#define LCRZO_ERR_FUGLOBALALLOC_entxt "error in GlobalAlloc()"
#define LCRZO_ERR_FUGLOBALALLOC_frtxt "erreur lors de l'appel GlobalAlloc()"
#define LCRZO_ERR_FUGETIPADDRTABLE 1086
#define LCRZO_ERR_FUGETIPADDRTABLE_entxt "error in GetIpAddrTable()"
#define LCRZO_ERR_FUGETIPADDRTABLE_frtxt "erreur lors de l'appel GetIpAddrTable()"
#define LCRZO_ERR_FUGETIPNETTABLE 1087
#define LCRZO_ERR_FUGETIPNETTABLE_entxt "error in GetIpNetTable()"
#define LCRZO_ERR_FUGETIPNETTABLE_frtxt "erreur lors de l'appel GetIpNetTable()"
#define LCRZO_ERR_FUGETIPFORWARDTABLE 1088
#define LCRZO_ERR_FUGETIPFORWARDTABLE_entxt "error in GetIpForwardTable()"
#define LCRZO_ERR_FUGETIPFORWARDTABLE_frtxt "erreur lors de l'appel GetIpForwardTable()"
#define LCRZO_ERR_FUGETNUMBEROFINTERFACES 1089
#define LCRZO_ERR_FUGETNUMBEROFINTERFACES_entxt "error in GetNumberOfInterfaces()"
#define LCRZO_ERR_FUGETNUMBEROFINTERFACES_frtxt "erreur lors de l'appel GetNumberOfInterfaces()"
#define LCRZO_ERR_FUWSASTARTUP 1090
#define LCRZO_ERR_FUWSASTARTUP_entxt "error in WSAStartup()"
#define LCRZO_ERR_FUWSASTARTUP_frtxt "erreur lors de l'appel WSAStartup()"
#define LCRZO_ERR_FUWSASTARTUPVER 1091
#define LCRZO_ERR_FUWSASTARTUPVER_entxt "error in WSAStartup() (bad Winsock version)"
#define LCRZO_ERR_FUWSASTARTUPVER_frtxt "erreur lors de l'appel WSAStartup() (mauvaise version de Winsock)"
#define LCRZO_ERR_FUWSACLEANUP 1092
#define LCRZO_ERR_FUWSACLEANUP_entxt "error in WSACleanup()"
#define LCRZO_ERR_FUWSACLEANUP_frtxt "erreur lors de l'appel WSACleanup()"
#define LCRZO_ERR_FUCHSIZE 1093
#define LCRZO_ERR_FUCHSIZE_entxt "error in chsize()"
#define LCRZO_ERR_FUCHSIZE_frtxt "erreur lors de l'appel chsize()"
#define LCRZO_ERR_FUFINDFIRST 1094
#define LCRZO_ERR_FUFINDFIRST_entxt "error in findfirst()"
#define LCRZO_ERR_FUFINDFIRST_frtxt "erreur lors de l'appel findfirst()"
#define LCRZO_ERR_FUFINDCLOSE 1095
#define LCRZO_ERR_FUFINDCLOSE_entxt "error in findclose()"
#define LCRZO_ERR_FUFINDCLOSE_frtxt "erreur lors de l'appel findclose()"
#define LCRZO_ERR_FUGETSTDHANDLE 1096
#define LCRZO_ERR_FUGETSTDHANDLE_entxt "error in GetStdHandle()"
#define LCRZO_ERR_FUGETSTDHANDLE_frtxt "erreur lors de l'appel GetStdHandle()"
#define LCRZO_ERR_FUPEEKCONSOLEINPUT 1097
#define LCRZO_ERR_FUPEEKCONSOLEINPUT_entxt "error in PeekConsoleInput()"
#define LCRZO_ERR_FUPEEKCONSOLEINPUT_frtxt "erreur lors de l'appel PeekConsoleInput()"
#define LCRZO_ERR_FUCREATEPIPE 1098
#define LCRZO_ERR_FUCREATEPIPE_entxt "error in CreatePipe()"
#define LCRZO_ERR_FUCREATEPIPE_frtxt "erreur lors de l'appel CreatePipe()"
#define LCRZO_ERR_FUREADFILE 1099
#define LCRZO_ERR_FUREADFILE_entxt "error in ReadFile()"
#define LCRZO_ERR_FUREADFILE_frtxt "erreur lors de l'appel ReadFile()"
#define LCRZO_ERR_10_END 1099

#define LCRZO_ERR_11_BEGIN 1100
#define LCRZO_ERR_FUWRITEFILE 1100
#define LCRZO_ERR_FUWRITEFILE_entxt "error in WriteFile()"
#define LCRZO_ERR_FUWRITEFILE_frtxt "erreur lors de l'appel WriteFile()"
#define LCRZO_ERR_FUPEEKNAMEDPIPE 1101
#define LCRZO_ERR_FUPEEKNAMEDPIPE_entxt "error in PeekNamedPipe()"
#define LCRZO_ERR_FUPEEKNAMEDPIPE_frtxt "erreur lors de l'appel PeekNamedPipe()"
#define LCRZO_ERR_FUTLSALLOC 1102
#define LCRZO_ERR_FUTLSALLOC_entxt "error in PeekNamedPipe()"
#define LCRZO_ERR_FUTLSALLOC_frtxt "erreur lors de l'appel PeekNamedPipe()"
#define LCRZO_ERR_FUTLSFREE 1103
#define LCRZO_ERR_FUTLSFREE_entxt "error in TlsFree()"
#define LCRZO_ERR_FUTLSFREE_frtxt "erreur lors de l'appel TlsFree()"
#define LCRZO_ERR_FUTLSSETVALUE 1104
#define LCRZO_ERR_FUTLSSETVALUE_entxt "error in TlsSetValue()"
#define LCRZO_ERR_FUTLSSETVALUE_frtxt "erreur lors de l'appel TlsSetValue()"
#define LCRZO_ERR_FUTLSGETVALUE 1105
#define LCRZO_ERR_FUTLSGETVALUE_entxt "error in TlsGetValue()"
#define LCRZO_ERR_FUTLSGETVALUE_frtxt "erreur lors de l'appel TlsGetValue()"
#define LCRZO_ERR_FULOCALALLOC 1106
#define LCRZO_ERR_FULOCALALLOC_entxt "error in LocalAlloc()"
#define LCRZO_ERR_FULOCALALLOC_frtxt "erreur lors de l'appel LocalAlloc()"
#define LCRZO_ERR_FULOCALFREE 1107
#define LCRZO_ERR_FULOCALFREE_entxt "error in LocalFree()"
#define LCRZO_ERR_FULOCALFREE_frtxt "erreur lors de l'appel LocalFree()"
#define LCRZO_ERR_FUPACKETOPENADAPTER 1108
#define LCRZO_ERR_FUPACKETOPENADAPTER_entxt "error in PacketOpenAdapter()"
#define LCRZO_ERR_FUPACKETOPENADAPTER_frtxt "erreur lors de l'appel PacketOpenAdapter()"
#define LCRZO_ERR_FUPACKETSETBUFF 1109
#define LCRZO_ERR_FUPACKETSETBUFF_entxt "error in PacketSetBuff()"
#define LCRZO_ERR_FUPACKETSETBUFF_frtxt "erreur lors de l'appel PacketSetBuff()"
#define LCRZO_ERR_FUPACKETALLOCATEPACKET 1110
#define LCRZO_ERR_FUPACKETALLOCATEPACKET_entxt "error in PacketAllocatePacket()"
#define LCRZO_ERR_FUPACKETALLOCATEPACKET_frtxt "erreur lors de l'appel PacketAllocatePacket()"
#define LCRZO_ERR_FUPACKETSENDPACKET 1111
#define LCRZO_ERR_FUPACKETSENDPACKET_entxt "error in PacketSendPacket()"
#define LCRZO_ERR_FUPACKETSENDPACKET_frtxt "erreur lors de l'appel PacketSendPacket()"
#define LCRZO_ERR_FUSETTHREADPRIORITY 1112
#define LCRZO_ERR_FUSETTHREADPRIORITY_entxt "error in SetThreadPriority()"
#define LCRZO_ERR_FUSETTHREADPRIORITY_frtxt "erreur lors de l'appel SetThreadPriority()"
#define LCRZO_ERR_FUGETTHREADPRIORITY 1113
#define LCRZO_ERR_FUGETTHREADPRIORITY_entxt "error in GetThreadPriority()"
#define LCRZO_ERR_FUGETTHREADPRIORITY_frtxt "erreur lors de l'appel GetThreadPriority()"
#define LCRZO_ERR_FUGETPRIORITY 1114
#define LCRZO_ERR_FUGETPRIORITY_entxt "error in getpriority()"
#define LCRZO_ERR_FUGETPRIORITY_frtxt "erreur lors de l'appel getpriority()"
#define LCRZO_ERR_FUSETPRIORITY 1115
#define LCRZO_ERR_FUSETPRIORITY_entxt "error in setpriority()"
#define LCRZO_ERR_FUSETPRIORITY_frtxt "erreur lors de l'appel setpriority()"
#define LCRZO_ERR_FUSOCKET 1116
#define LCRZO_ERR_FUSOCKET_entxt "error in socket()"
#define LCRZO_ERR_FUSOCKET_frtxt "erreur lors de l'appel a socket()"
#define LCRZO_ERR_FUREGQUERYINFOKEY 1117
#define LCRZO_ERR_FUREGQUERYINFOKEY_entxt "error in RegQueryInfoKey()"
#define LCRZO_ERR_FUREGQUERYINFOKEY_frtxt "erreur lors de l'appel a RegQueryInfoKey()"
#define LCRZO_ERR_FUREGENUMKEY 1118
#define LCRZO_ERR_FUREGENUMKEY_entxt "error in RegEnumKey()"
#define LCRZO_ERR_FUREGENUMKEY_frtxt "erreur lors de l'appel a RegEnumKey()"
#define LCRZO_ERR_FUREGENUMVALUE 1119
#define LCRZO_ERR_FUREGENUMVALUE_entxt "error in RegEnumValue()"
#define LCRZO_ERR_FUREGENUMVALUE_frtxt "erreur lors de l'appel a RegEnumValue()"
#define LCRZO_ERR_FUCREATEFILE 1120
#define LCRZO_ERR_FUCREATEFILE_entxt "error in CreateFile()"
#define LCRZO_ERR_FUCREATEFILE_frtxt "erreur lors de l'appel a CreateFile()"
#define LCRZO_ERR_FUDEVICEIOCONTROL 1121
#define LCRZO_ERR_FUDEVICEIOCONTROL_entxt "error in DeviceIoControl()"
#define LCRZO_ERR_FUDEVICEIOCONTROL_frtxt "erreur lors de l'appel a DeviceIoControl()"
#define LCRZO_ERR_FUPACKETREQUEST 1122
#define LCRZO_ERR_FUPACKETREQUEST_entxt "error in PacketRequest()"
#define LCRZO_ERR_FUPACKETREQUEST_frtxt "erreur lors de l'appel a PacketRequest()"
#define LCRZO_ERR_FUPACKETGETADAPTERNAMES 1123
#define LCRZO_ERR_FUPACKETGETADAPTERNAMES_entxt "error in PacketGetAdapterNames()"
#define LCRZO_ERR_FUPACKETGETADAPTERNAMES_frtxt "erreur lors de l'appel a PacketGetAdapterNames()"
#define LCRZO_ERR_FUGETIFTABLE 1124
#define LCRZO_ERR_FUGETIFTABLE_entxt "error in GetIfTable()"
#define LCRZO_ERR_FUGETIFTABLE_frtxt "erreur lors de l'appel a GetIfTable()"
#define LCRZO_ERR_FUMPROTECT 1125
#define LCRZO_ERR_FUMPROTECT_entxt "error in mprotect()"
#define LCRZO_ERR_FUMPROTECT_frtxt "erreur lors de l'appel a mprotect()"
#define LCRZO_ERR_11_END 1125


/*-------------------------------------------------------------*/
/*en Name : lcrzo_err_fprint
   Description :
     Print the text associated with an error code.
   Input parameter(s) :
     *pf : FILE where the function prints
     error : the text associated to this error is printed
   Input/output parameter(s) :
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_err_fprint
   Description :
     Ecrit le texte associe a un code d'erreur.
   Parametre(s) d'entree :
     *pf : FILE ou la fonction doit ecrire
     error : numero de l'erreur dont on doit ecrire le texte
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_err_fprint(LCRZOFILE *pf,
		     int error);

/*en idem, but on stdout */
/*fr idem, mais sur stdout */
#define lcrzo_err_print(a) lcrzo_err_fprint(stdout, a)

/*en this function can be used to purge error strings if you
   want to ignore an error. You should not need to use it. */
/*fr cette fonction purge le texte d'erreur, si vous desirez
   ignorer une erreur. Vous ne devriez pas en avoir besoin. */
int lcrzo_err_purge(void);

/*-------------------------------------------------------------*/
/*EN*********************************************************
 * Note about these defines :                               *
 * These defines allow to easily test for return codes.     *
 * For example, instead of writing :                        *
 *    ret=function(...);                                    *
 *    if (ret!=LCRZO_ERR_OK)                                *
 *    { lcrzo_err_print(retour);                            *
 *      return(ret);                                        *
 *    }                                                     *
 * You only need to write :                                 *
 *    lcrzo_evr(function(...));                             *
 *                                                          *
 * In these defines :                                       *
 *   z is the variable containing the return code           *
 *   i is the variable containing the wanted return code    *
 *   f is the variable containing functions which can be    *
 *     called on exit                                       *
 ************************************************************/
/*FR*********************************************************
 * Note sur les defines qui suivent :                       *
 * Ces defines permettent de tester aisement des codes de   *
 * retour.                                                  *
 * Par exemple, au lieu d'ecrire :                          *
 *    ret=function(...);                                    *
 *    if (ret!=LCRZO_ERR_OK)                                *
 *    { lcrzo_err_print(retour);                            *
 *      return(ret);                                        *
 *    }                                                     *
 * Il suffit d'ecrire :                                     *
 *    lcrzo_evr(function(...));                             *
 *                                                          *
 * Dans ces defines :                                       *
 *   z est la variable contenant le code de retour          *
 *   i est la variable contenant le code de retour voulu    *
 *   f est la variable contenant les fonctions pouvant etre *
 *     appelees lors de la sortie                           *
 ************************************************************/

/*-------------------------------------------------------------*/
/* if (z!=LCRZO_ERR_OK) return(z) */
#define lcrzo_er(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK)return(lcrzo_coderr);}

/* if (z!=LCRZO_ERR_OK) lcrzo_err_print(z) */
#define lcrzo_ep(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK)lcrzo_err_print(lcrzo_coderr);}

/* if (z!=LCRZO_ERR_OK) { lcrzo_err_print(z); return(z) } */
#define lcrzo_epr(z) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){lcrzo_err_print(lcrzo_coderr);return(lcrzo_coderr);}}

/* if (z!=LCRZO_ERR_OK) { gotoret=z; goto g; } */
#define lcrzo_eg(z,g) {int lcrzo_coderr=z;if(lcrzo_coderr!=LCRZO_ERR_OK){gotoret=lcrzo_coderr; goto g;};}

/* lcrzo_err_print(z); if (z!=LCRZO_ERR_OK) return(z) */
#define lcrzo_evr(z) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=LCRZO_ERR_OK)return(lcrzo_coderr);}

/*-------------------------------------------------------------*/
/* if (z!=i) lcrzo_err_print(z) */
#define lcrzo_eip(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)lcrzo_err_print(LCRZO_ERR_IEOKKO);lcrzo_err_print(lcrzo_coderr);}}

/* if (z!=i) return(z) */
#define lcrzo_eir(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);return(lcrzo_coderr);}}

/* if (z!=i) { lcrzo_err_print(z); return(z) } */
#define lcrzo_eipr(z,i) {int lcrzo_coderr=z;if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK){lcrzo_err_print(LCRZO_ERR_IEOKKO);return(LCRZO_ERR_IEOKKO);}lcrzo_err_print(lcrzo_coderr);return(lcrzo_coderr);}}

/* lcrzo_err_print(z); if (z!=i) return(z) */
#define lcrzo_eivr(z,i) {int lcrzo_coderr=z;lcrzo_err_print(lcrzo_coderr);if(lcrzo_coderr!=i){if(lcrzo_coderr==LCRZO_ERR_OK)return(LCRZO_ERR_IEOKKO);return(lcrzo_coderr);}}





