/*en    Laurent Constantin's network library (lcrzo)
                 lcrzo_spoof module

  Functions herein allow to spoof packets.
*/
/*fr    Bibliotheque reseau de Laurent Constantin (lcrzo)
                 Module lcrzo_spoof

  Les fonctions presentes dans ce module permettent d'envoyer
  des packets spoofes.
*/

/*-------------------------------------------------------------*/
/*en definition of a lcrzo_spoof. You should not use its 
   fields directly. */
/*fr definition d'un lcrzo_spoof. Vous ne devriez pas utiliser 
   directement ses champs. */
/*-------------------------------------------------------------*/
typedef struct
{ lcrzo_int16 spooftype;
  lcrzo_device device;
  lcrzo_uint16       para_fragoctosize;
  lcrzo_bool         para_printbeforesending;
  lcrzo_printprofile para_printprofile;
  lcrzo_bool         para_useethforip;
  int fd;
  void *plli;
  void *padapter;
} lcrzo_spoof;

/*-------------------------------------------------------------*/
/*en Name : lcrzo_spoof_init
   Description :
     Initialize a lcrzo_spoof.
   Input parameter(s) :
   Input/output parameter(s) :
   Output parameter(s) :
     *pspoof : lcrzo_spoof initialized
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_init
   Description :
     Initialise un lcrzo_spoof.
   Parametre(s) d'entree :
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *pspoof : lcrzo_spoof initialise
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_init(lcrzo_spoof *pspoof);

/*en Name : lcrzo_spoof_close
   Description :
     Close a lcrzo_spoof.
   Input parameter(s) :
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof to close
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_close
   Description :
     Ferme un lcrzo_spoof.
   Parametre(s) d'entree :
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof a fermer
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_close(lcrzo_spoof *pspoof);

/*-------------------------------------------------------------*/
/*en Name : lcrzo_spoof_eth
   Description :
     Spoof an Ethernet packet.
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     packet : packet to send
     packetsize : size of packet
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_eth
   Description :
     Spoofe (emet sur le reseau) un paquet Ethernet
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     packet : paquet a envoyer
     packetsize : taille de packet
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_eth(lcrzo_spoof *pspoof,
		    lcrzo_constdevice device, 
		    lcrzo_constdata packet, 
		    lcrzo_int32 packetsize);

/*en Name : lcrzo_spoof_ip
   Description :
     Spoof an IP packet.
   Input parameter(s) :
     packet : packet to send
     packetsize : size of packet
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ip
   Description :
     Spoofe (emet sur le reseau) un paquet IP
   Parametre(s) d'entree :
     packet : paquet a envoyer
     packetsize : taille de packet
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ip(lcrzo_spoof *pspoof,
		   lcrzo_constdata packet,
		   lcrzo_int32 packetsize);


/*-------------------------------------------------------------*/
/*en Name : lcrzo_spoof_ipoptdata
   Description :
     Spoof an packet with {IP header, IP options, IP data}
   Input parameter(s) :
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     data : IP data
     datasize : IP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ipoptdata
   Description :
     Spoofe un paquet avec {entete IP, options IP, donnees IP}
   Parametre(s) d'entree :
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     data : donnees IP
     datasize : taille des donnees IP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ipoptdata(lcrzo_spoof *pspoof,
			  lcrzo_hdrlip hdrlip,
			  lcrzo_constipopt ipopt,
			  lcrzo_uint8 ipoptsize,
			  lcrzo_constdata data,
			  lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ipoptudpdata
   Description :
     Spoof an packet with {IP header, IP options, 
     UDP header, UDP data}
   Input parameter(s) :
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrludp : UDP header
     data : UDP data
     datasize : UDP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ipoptudpdata
   Description :
     Spoofe un paquet avec {entete IP, options IP,
     entete UDP, donnees UDP}
   Parametre(s) d'entree :
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrludp : entete UDP
     data : donnees UDP
     datasize : taille des donnees UDP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ipoptudpdata(lcrzo_spoof *pspoof,
			     lcrzo_hdrlip hdrlip,
			     lcrzo_constipopt ipopt,
			     lcrzo_uint8 ipoptsize,
			     lcrzo_hdrludp hdrludp,
			     lcrzo_constdata data,
			     lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ipopttcpoptdata
   Description :
     Spoof an packet with {IP header, IP options, 
     TCP header, TCP options, TCP data}
   Input parameter(s) :
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrltcp : TCP header
     tcpopt : TCP options
     tcpoptsize : TCP options size
     data : TCP data
     datasize : TCP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ipopttcpoptdata
   Description :
     Spoofe un paquet avec {entete IP, options IP,
     entete TCP, options TCP, donnees TCP}
   Parametre(s) d'entree :
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrltcp : entete TCP
     tcpopt : options TCP
     tcpoptsize : taille des options TCP
     data : donnees TCP
     datasize : taille des donnees TCP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ipopttcpoptdata(lcrzo_spoof *pspoof,
				lcrzo_hdrlip hdrlip,
				lcrzo_constipopt ipopt,
				lcrzo_uint8 ipoptsize,
				lcrzo_hdrltcp hdrltcp,
				lcrzo_consttcpopt tcpopt,
				lcrzo_uint8 tcpoptsize,
				lcrzo_constdata data,
				lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ipopticmpdata
   Description :
     Spoof an packet with {IP header, IP options, 
     ICMP header, ICMP data}
   Input parameter(s) :
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrlicmp : ICMP header
     data : ICMP data
     datasize : ICMP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ipopticmpdata
   Description :
     Spoofe un paquet avec {entete IP, options IP,
     entete ICMP, donnees ICMP}
   Parametre(s) d'entree :
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrlicmp : entete ICMP
     data : donnees ICMP
     datasize : taille des donnees ICMP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ipopticmpdata(lcrzo_spoof *pspoof,
			      lcrzo_hdrlip hdrlip,
			      lcrzo_constipopt ipopt,
			      lcrzo_uint8 ipoptsize,
			      lcrzo_hdrlicmp hdrlicmp,
			      lcrzo_constdata data,
			      lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ethdata
   Description :
     Spoof an packet with {Ethernet header, Ethernet data}
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     data : Ethernet data
     datasize : Ethernet data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ethdata
   Description :
     Spoofe un paquet avec {entete Ethernet, donnees Ethernet}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     data : donnees Ethernet
     datasize : taille des donnees Ethernet
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ethdata(lcrzo_spoof *pspoof,
			lcrzo_constdevice device,
			lcrzo_hdrleth hdrleth,
			lcrzo_constdata data,
			lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ethipoptdata
   Description :
     Spoof an packet with {Ethernet header, IP header, 
     IP options, IP data }
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     data : IP data
     datasize : IP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ethipoptdata
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     options IP, donnees IP}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     data : donnees IP
     datasize : taille des donnees IP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ethipoptdata(lcrzo_spoof *pspoof,
			     lcrzo_constdevice device,
			     lcrzo_hdrleth hdrleth,
			     lcrzo_hdrlip hdrlip,
			     lcrzo_constipopt ipopt,
			     lcrzo_uint8 ipoptsize,
			     lcrzo_constdata data,
			     lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ethipoptudpdata
   Description :
     Spoof an packet with {Ethernet header, IP header, 
     IP options, UDP header, UDP data}
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrludp : UDP header
     data : UDP data
     datasize : UDP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ethipoptudpdata
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     options IP, entete UDP, donnees UDP}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrludp : entete UDP
     data : donnees UDP
     datasize : taille des donnees UDP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ethipoptudpdata(lcrzo_spoof *pspoof,
				lcrzo_constdevice device,
				lcrzo_hdrleth hdrleth,
				lcrzo_hdrlip hdrlip,
				lcrzo_constipopt ipopt, 
				lcrzo_uint8 ipoptsize,
				lcrzo_hdrludp hdrludp,
				lcrzo_constdata data,
				lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ethipopttcpoptdata
   Description :
     Spoof an packet with {Ethernet header, IP header, 
     IP options, TCP header, TCP options, TCP data}
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrltcp : TCP header
     tcpopt : TCP options
     tcpoptsize : TCP options size
     data : TCP data
     datasize : TCP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ethipopttcpoptdata
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     options IP, entete TCP, options TCP, donnees TCP}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrltcp : entete TCP
     tcpopt : options TCP
     tcpoptsize : taille des options TCP
     data : donnees TCP
     datasize : taille des donnees TCP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ethipopttcpoptdata(lcrzo_spoof *pspoof,
				   lcrzo_constdevice device,
				   lcrzo_hdrleth hdrleth,
				   lcrzo_hdrlip hdrlip,
				   lcrzo_constipopt ipopt,
				   lcrzo_uint8 ipoptsize,
				   lcrzo_hdrltcp hdrltcp,
				   lcrzo_consttcpopt tcpopt,
				   lcrzo_uint8 tcpoptsize,
				   lcrzo_constdata data,
				   lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_ethipopticmpdata
   Description :
     Spoof an packet with {Ethernet header, IP header, 
     IP options, ICMP header, ICMP data}
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     hdrlip : IP header
     ipopt : IP options
     ipoptsize : IP options size
     hdrlicmp : ICMP header
     data : ICMP data
     datasize : ICMP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_ethipopticmpdata
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     options IP, entete ICMP, donnees ICMP}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     hdrlip : entete IP
     ipopt : options IP
     ipoptsize : taille des options IP
     hdrlicmp : entete ICMP
     data : donnees ICMP
     datasize : taille des donnees ICMP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_ethipopticmpdata(lcrzo_spoof *pspoof,
				 lcrzo_constdevice device,
				 lcrzo_hdrleth hdrleth,
				 lcrzo_hdrlip hdrlip,
				 lcrzo_constipopt ipopt, 
				 lcrzo_uint8 ipoptsize,
				 lcrzo_hdrlicmp hdrlicmp,
				 lcrzo_constdata data,
				 lcrzo_uint16 datasize);

/*en Name : lcrzo_spoof_etharp
   Description :
     Spoof an packet with {Ethernet header, ARP/RARP header}
   Input parameter(s) :
     device : device where to send the packet (ex: "eth0")
     hdrleth : Ethernet header
     hdrlarp : ARP header
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_etharp
   Description :
     Spoofe un paquet avec {entete Ethernet, entete ARP/RARP}
   Parametre(s) d'entree :
     device : device a utiliser (ex: "eth0")
     hdrleth : entete Ethernet
     hdrlarp : entete ARP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_etharp(lcrzo_spoof *pspoof,
		       lcrzo_constdevice device,
		       lcrzo_hdrleth hdrleth,
		       lcrzo_hdrlarp hdrlarp);

/*-------------------------------------------------------------*/
/*en Name : lcrzo_spoof_get_fd
   Description :
     Get the associated file descriptors.
   Input parameter(s) :
     *pspoof : lcrzo_spoof from which obtain fds 
   Input/output parameter(s) :
   Output parameter(s) :
     *pwritefd : file descriptor used for writing (-1 if closed)
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoof_get_fd
   Description :
     Obtient les descripteurs de fichier.
   Parametre(s) d'entree :
     *pspoof : lcrzo_spoof dont on veut les fds
   Parametre(s) d'entree-sortie :
   Parametre(s) de sortie :
     *pwritefd : descripteur de fichier utilise en ecriture (-1 si ferme)
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoof_get_fd(lcrzo_spoof *pspoof, 
		       int *pwritefd);


/*-------------------------------------------------------------*/
/*EN************************************************************
 * Note about lcrzo_spoofeasy_xxx :                            *
 * These functions send easy packets. Indeed, in most cases,   *
 * we do not need to specify ip.id, tcp.windows, etc.          *
 ***************************************************************/
/*FR************************************************************
 * Note sur les lcrzo_spoofeasy_xxx :                          *
 * Ces fonctions envoient des packets simples. En effet, dans  *
 * la majorite des cas, on ne veut pas specifier l'id, la      *
 * window, le type eth, etc.                                   *
 ***************************************************************/

/*en Name : lcrzo_spoofeasy_ipudp
   Description :
     Spoof an packet with {IP header, UDP header, UDP data}
   Input parameter(s) :
     srcipl : IP source address
     dstipl : IP destination address 
     srcport : source port
     dstport : destination port
     udpdata : UDP data
     udpdatasize : UDP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_ipudp
   Description :
     Spoofe un paquet avec {entete IP, entete UDP, donnees UDP}
   Parametre(s) d'entree :
     srcipl : adresse IP source
     dstipl : adresse IP destination
     srcport : port source
     dstport : port destination
     udpdata : donnees UDP
     udpdatasize : taille des donnees UDP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_ipudp(lcrzo_ipl srcipl,
			  lcrzo_ipl dstipl,
			  lcrzo_uint16 srcport,
			  lcrzo_uint16 dstport,
			  lcrzo_constdata udpdata,  
			  lcrzo_uint16 udpdatasize);

/*en Name : lcrzo_spoofeasy_iptcp
   Description :
     Spoof an packet with {IP header, TCP header, TCP data}
   Input parameter(s) :
     srcipl : IP source address
     dstipl : IP destination address 
     srcport : source port
     dstport : destination port
     seqnum : sequence number
     acknum : acknowledge number
     syn : bit syn
     ack : bit ack
     fin : bit fin
     rst : bit rst
     tcpdata : TCP data
     tcpdatasize : TCP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_iptcp
   Description :
     Spoofe un paquet avec {entete IP, entete TCP, donnees TCP}
   Parametre(s) d'entree :
     srcipl : adresse IP source
     dstipl : adresse IP destination
     srcport : port source
     dstport : port destination
     seqnum : numero de sequence
     acknum : numero d'acquittement
     syn : bit syn
     ack : bit ack
     fin : bit fin
     rst : bit rst
     tcpdata : donnees TCP
     tcpdatasize : taille des donnees TCP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_iptcp(lcrzo_ipl srcipl,
			  lcrzo_ipl dstipl,
			  lcrzo_uint16 srcport,
			  lcrzo_uint16 dstport,
			  lcrzo_uint32 seqnum,
			  lcrzo_uint32 acknum,
			  lcrzo_bool syn,
			  lcrzo_bool ack, 
			  lcrzo_bool fin,
			  lcrzo_bool rst,
			  lcrzo_constdata tcpdata,  
			  lcrzo_uint16 tcpdatasize);

/*en Name : lcrzo_spoofeasy_ipicmp
   Description :
     Spoof an packet with {IP header, ICMP header, ICMP data}
   Input parameter(s) :
     srcipl : IP source address
     dstipl : IP destination address 
     type : ICMP type
     code : ICMP code
     icmpdata : ICMP data
     icmpdatasize : ICMP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_ipicmp
   Description :
     Spoofe un paquet avec {entete IP, entete ICMP, donnees ICMP}
   Parametre(s) d'entree :
     srcipl : adresse IP source
     dstipl : adresse IP destination
     type : type ICMP
     code : code ICMP
     icmpdata : donnees ICMP
     icmpdatasize : taille des donnees ICMP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_ipicmp(lcrzo_ipl srcipl,
			   lcrzo_ipl dstipl,
			   lcrzo_uint8 type,
			   lcrzo_uint8 code,
			   lcrzo_constdata icmpdata,  
			   lcrzo_uint16 icmpdatasize);

/*en Name : lcrzo_spoofeasy_ethipudp
   Description :
     Spoof an packet with {Ethernet header, IP header, UDP header, UDP data}
   Input parameter(s) :
     device : device where the packet has to be sent
     srcetha : Ethernet source address
     dstetha : Ethernet destination address 
     srcipl : IP source address
     dstipl : IP destination address 
     srcport : source port
     dstport : destination port
     udpdata : UDP data
     udpdatasize : UDP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_ethipudp
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP, 
     entete UDP, donnees UDP}
   Parametre(s) d'entree :
     device : device sur lequel le paquet est emis
     srcetha : adresse Ethernet source
     dstetha : adresse Ethernet destination
     srcipl : adresse IP source
     dstipl : adresse IP destination
     srcport : port source
     dstport : port destination
     udpdata : donnees UDP
     udpdatasize : taille des donnees UDP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_ethipudp(lcrzo_constdevice device,
			     lcrzo_constetha srcetha,
			     lcrzo_constetha dstetha,
			     lcrzo_ipl srcipl,
			     lcrzo_ipl dstipl,
			     lcrzo_uint16 srcport,
			     lcrzo_uint16 dstport,
			     lcrzo_constdata udpdata,  
			     lcrzo_uint16 udpdatasize);

/*en Name : lcrzo_spoofeasy_ethiptcp
   Description :
     Spoof an packet with {Ethernet header, IP header, TCP header, TCP data}
   Input parameter(s) :
     device : device where the packet has to be sent
     srcetha : Ethernet source address
     dstetha : Ethernet destination address 
     srcipl : IP source address
     dstipl : IP destination address 
     srcport : source port
     dstport : destination port
     seqnum : sequence number
     acknum : acknowledge number
     syn : bit syn
     ack : bit ack
     fin : bit fin
     rst : bit rst
     tcpdata : TCP data
     tcpdatasize : TCP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_ethiptcp
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     entete TCP, donnees TCP}
   Parametre(s) d'entree :
     device : device sur lequel le paquet est emis
     srcetha : adresse Ethernet source
     dstetha : adresse Ethernet destination
     srcipl : adresse IP source
     dstipl : adresse IP destination
     srcport : port source
     dstport : port destination
     seqnum : numero de sequence
     acknum : numero d'acquittement
     syn : bit syn
     ack : bit ack
     fin : bit fin
     rst : bit rst
     tcpdata : donnees TCP
     tcpdatasize : taille des donnees TCP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_ethiptcp(lcrzo_constdevice device,
			     lcrzo_constetha srcetha,
			     lcrzo_constetha dstetha,
			     lcrzo_ipl srcipl,
			     lcrzo_ipl dstipl,
			     lcrzo_uint16 srcport,
			     lcrzo_uint16 dstport,
			     lcrzo_uint32 seqnum,
			     lcrzo_uint32 acknum,
			     lcrzo_bool syn,
			     lcrzo_bool ack, 
			     lcrzo_bool fin,
			     lcrzo_bool rst,
			     lcrzo_constdata tcpdata,  
			     lcrzo_uint16 tcpdatasize);

/*en Name : lcrzo_spoofeasy_ethipicmp
   Description :
     Spoof an packet with {Ethernet header, IP header, ICMP header, ICMP data}
   Input parameter(s) :
     device : device where the packet has to be sent
     srcetha : Ethernet source address
     dstetha : Ethernet destination address 
     srcipl : IP source address
     dstipl : IP destination address 
     type : ICMP type
     code : ICMP code
     icmpdata : ICMP data
     icmpdatasize : ICMP data size
   Input/output parameter(s) :
     *pspoof : lcrzo_spoof where to work
   Output parameter(s) :
   Normal return values :
     LCRZO_ERR_OK : ok
*/
/*fr Nom : lcrzo_spoofeasy_ethipicmp
   Description :
     Spoofe un paquet avec {entete Ethernet, entete IP,
     entete ICMP, donnees ICMP}
   Parametre(s) d'entree :
     device : device sur lequel le paquet est emis
     srcetha : adresse Ethernet source
     dstetha : adresse Ethernet destination
     srcipl : adresse IP source
     dstipl : adresse IP destination
     type : type ICMP
     code : code ICMP
     icmpdata : donnees ICMP
     icmpdatasize : taille des donnees ICMP
   Parametre(s) d'entree-sortie :
     *pspoof : lcrzo_spoof de travail
   Parametre(s) de sortie :
   Valeurs de retour normales :
     LCRZO_ERR_OK : ok
*/
int lcrzo_spoofeasy_ethipicmp(lcrzo_constdevice device,
			      lcrzo_constetha srcetha,
			      lcrzo_constetha dstetha,
			      lcrzo_ipl srcipl,
			      lcrzo_ipl dstipl,
			      lcrzo_uint8 type,
			      lcrzo_uint8 code,
			      lcrzo_constdata icmpdata,  
			      lcrzo_uint16 icmpdatasize);

/*-------------------------------------------------------------*/
/*en if we want to fragment, we can set the fragoctosize of
   a lcrzo_spoof. This value corresponds to
     maximum_IP_data_size / 8
   For example, to send packets with only 24 bytes of data :
     lcrzo_spoof_set_fragoctosize(&spoof, 3);
*/
/*fr si l'on veut emettre des paquets fragmentes, on peut 
   affecter le fragoctosize d'un lcrzo_spoof. Cette valeur
   correspond a :
     taille_maxi_des_donnees_IP / 8
   Par exemple, pour envoyer des paquets avec uniquement
   24 octets de donnees :
     lcrzo_spoof_set_fragoctosize(&spoof, 3);
 */
int lcrzo_spoof_set_fragoctosize(lcrzo_spoof *pspoof,
				 lcrzo_uint16 fragoctosize);
int lcrzo_spoof_get_fragoctosize(lcrzo_spoof *pspoof,
				 lcrzo_uint16 *pfragoctosize);

/*-------------------------------------------------------------*/
/*en we can set this value if we want to print every packet
   sent by a lcrzo_spoof. For example :
     lcrzo_spoof_set_printbeforesending(&spoof, 1);
*/
/*fr on peut affecter cette valeur si l'on veut afficher 
   tous les paquets avant qu'ils soient emis sur le reseau.
   Par exemple :
     lcrzo_spoof_set_printbeforesending(&spoof, 1);
*/
int lcrzo_spoof_set_printbeforesending(lcrzo_spoof *pspoof,
				       lcrzo_bool printbeforesending);
int lcrzo_spoof_get_printbeforesending(lcrzo_spoof *pspoof,
				       lcrzo_bool *pprintbeforesending);

/*-------------------------------------------------------------*/
/*en if we print packets before sending them, we can change
   the way they are printed. For example :
     lcrzo_spoof_set_printprofile(&spoof, 
                                  LCRZO_PRINTPROFILE_HEXANCHMS);
*/
/*fr si on affiche les paquets avant de les emettre, on peut
  changer leur profil d'affichage. Par exemple :
     lcrzo_spoof_set_printprofile(&spoof, 
                                  LCRZO_PRINTPROFILE_HEXANCHMS);
*/
int lcrzo_spoof_set_printprofile(lcrzo_spoof *pspoof,
				 lcrzo_printprofile printprofile);
int lcrzo_spoof_get_printprofile(lcrzo_spoof *pspoof,
				 lcrzo_printprofile *pprintprofile);

/*-------------------------------------------------------------*/
/*en if we spoof ethernet packet when the user wants to only 
     spoof IP. This is very useful on systems like Solaris
     which modify IP header values. */
/*fr definit si l'on spoofe des paquets Ethernet lorsque l'utilisateur
     veut spoofer des paquets IP. C'est tres utile sur des 
     systemes comme Solaris qui modifient les valeurs des entetes
     IP. */
int lcrzo_spoof_set_useethforip(lcrzo_spoof *pspoof,
				lcrzo_bool useethforip);
int lcrzo_spoof_get_useethforip(lcrzo_spoof *pspoof,
				lcrzo_bool *puseethforip);
