/*************************************************
* Adler32 Header File                            *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ADLER32_H__
#define OPENCL_ADLER32_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* Adler32                                        *
*************************************************/
class Adler32 : public HashFunction
   {
   public:
      static const u32bit HASHLENGTH = 4;

      void clear() throw() { S1 = 1; S2 = 0; }
      std::string name() const { return "Adler32"; }
      HashFunction* clone() const { return new Adler32; }
      Adler32() : HashFunction(4) { clear(); }
      ~Adler32() { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[], u32bit);
      u32bit S1, S2;
   };

}

#endif
