/*************************************************
* Allocator Factory Source File                  *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ALLOCATION_H__
#define OPENCL_ALLOCATION_H__

#include <opencl/secalloc.h>

namespace OpenCL {

/*************************************************
* Get an allocator                               *
*************************************************/
SecureAllocator* get_allocator(const std::string& = "");

/*************************************************
* Release an allocator                           *
*************************************************/
void release_allocator(SecureAllocator*);

/*************************************************
* Set the default allocator type                 *
*************************************************/
void set_default_allocator(const std::string&);

/*************************************************
* Add new allocator type                         *
*************************************************/
bool add_allocator_type(const std::string&, SecureAllocator*);

}

#endif
