/*************************************************
* ARC4 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ARC4_H__
#define OPENCL_ARC4_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ARC4 : public StreamCipher
   {
   public:
      void clear() throw();
      std::string name() const { return (SKIP ? "MARK4" : "ARC4"); }
      StreamCipher* clone() const { return new ARC4(SKIP); }
      ARC4(u32bit = 0);
      ~ARC4() { clear(); }
   private:
      void cipher(const byte[], byte[], u32bit);
      void key(const byte[], u32bit);
      void generate();
      SecureBuffer<byte, 1024> buffer;
      SecureBuffer<u32bit, 256> state;
      u32bit X, Y, position;
      const u32bit SKIP;
   };

struct MARK4 : public ARC4
   {
   MARK4() : ARC4(256) {}
   };

}

#endif
