/*************************************************
* Blowfish Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_BLOWFISH_H__
#define OPENCL_BLOWFISH_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Blowfish : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw();
      std::string name() const { return "Blowfish"; }
      BlockCipher* clone() const { return new Blowfish; }
      Blowfish() : BlockCipher(8, 1, 32) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void round(u32bit&, u32bit&, u32bit) const;
      void generate_sbox(u32bit[], u32bit, u32bit&, u32bit&) const;
      static const u32bit PBOX[18], SBOX1[256], SBOX2[256],
                                    SBOX3[256], SBOX4[256];
      SecureBuffer<u32bit, 256> Sbox1, Sbox2, Sbox3, Sbox4;
      SecureBuffer<u32bit, 18> Pbox;
   };

}

#endif
