/*************************************************
* Buffering Filter Header File                   *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_BUFFERING_FILTER_H__
#define OPENCL_BUFFERING_FILTER_H__

#include <opencl/filter.h>

namespace OpenCL {

/*************************************************
* Buffering Filter                               *
*************************************************/
class BufferingFilter : public Filter
   {
   public:
      void write(const byte[], u32bit);
      virtual void end_msg();
      BufferingFilter(u32bit, u32bit = 0);
      virtual ~BufferingFilter() {}
   protected:
      virtual void initial_block(const byte[]) {}
      virtual void main_block(const byte[]) = 0;
      virtual void final_block(const byte[], u32bit) = 0;
   private:
      const u32bit INITIAL_BLOCK_SIZE, BLOCK_SIZE;
      SecureVector<byte> initial, block;
      u32bit initial_block_pos, block_pos;
   };

}

#endif
