/*************************************************
* CAST5 Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CAST5_H__
#define OPENCL_CAST5_H__

#include <opencl/opencl.h>

namespace OpenCL {

class CAST5 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { MK.clear(); RK.clear(); }
      std::string name() const { return "CAST5"; }
      BlockCipher* clone() const { return new CAST5; }
      CAST5() : BlockCipher(8, 11, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void round1(u32bit&, u32bit, u32bit) const;
      void round2(u32bit&, u32bit, u32bit) const;
      void round3(u32bit&, u32bit, u32bit) const;
      void key_schedule(SecureBuffer<u32bit, 16>&,
                        SecureBuffer<u32bit, 4>&) const;
      static const u32bit S5[256], S6[256], S7[256], S8[256];
      SecureBuffer<u32bit, 16> MK, RK;
   };

extern const u32bit CAST_SBOX1[256];
extern const u32bit CAST_SBOX2[256];
extern const u32bit CAST_SBOX3[256];
extern const u32bit CAST_SBOX4[256];

}

#endif
