/*************************************************
* CBC Mode Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CBC_H__
#define OPENCL_CBC_H__

#include <opencl/filter.h>
#include <opencl/modebase.h>
#include <opencl/mode_pad.h>

namespace OpenCL {

/*************************************************
* CBC Encryption                                 *
*************************************************/
template<typename B, typename P>
class CBC_Encryption : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();
      CBC_Encryption(const BlockCipherKey&, const BlockCipherModeIV&);
   private:
      BlockCipherModePaddingMethod* padder;
   };

/*************************************************
* CBC Decryption                                 *
*************************************************/
template<typename B, typename P>
class CBC_Decryption : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();
      CBC_Decryption(const BlockCipherKey&, const BlockCipherModeIV&);
   private:
      BlockCipherModePaddingMethod* padder;
      SecureVector<byte> temp;
   };

}

#endif

#ifndef OPENCL_CBC_ICC__
#define OPENCL_CBC_ICC__
#include <opencl/cbc.icc>
#endif
