/*************************************************
* CFB Mode Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CFB_H__
#define OPENCL_CFB_H__

#include <opencl/filter.h>
#include <opencl/modebase.h>

namespace OpenCL {

/*************************************************
* CFB Encryption                                 *
*************************************************/
template<typename B>
class CFB_Encryption : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      CFB_Encryption(const BlockCipherKey&, const BlockCipherModeIV&,
                     u32bit = 0);
   private:
      const u32bit FEEDBACKSIZE;
      void feedback();
   };

/*************************************************
* CFB Decryption                                 *
*************************************************/
template<typename B>
class CFB_Decryption : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      CFB_Decryption(const BlockCipherKey&, const BlockCipherModeIV&,
                     u32bit = 0);
   private:
      const u32bit FEEDBACKSIZE;
      void feedback();
   };

}

#endif

#ifndef OPENCL_CFB_ICC__
#define OPENCL_CFB_ICC__
#include <opencl/cfb.icc>
#endif
