/*************************************************
* CRC24 Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CRC24_H__
#define OPENCL_CRC24_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* CRC24                                          *
*************************************************/
class CRC24 : public HashFunction
   {
   public:
      static const u32bit HASHLENGTH = 3;

      void clear() throw() { crc = 0xB704CE; }
      std::string name() const { return "CRC24"; }
      HashFunction* clone() const { return new CRC24; }
      CRC24() : HashFunction(3) { clear(); }
      ~CRC24() { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      static const u32bit TABLE[256];
      u32bit crc;
   };

}

#endif
