/*************************************************
* DESX Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_DESX_H__
#define OPENCL_DESX_H__

#include <opencl/des.h>

namespace OpenCL {

class DESX : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { des.clear(); K1.clear(); K2.clear(); }
      std::string name() const { return "DESX"; }
      BlockCipher* clone() const { return new DESX; }
      DESX() : BlockCipher(8, 24) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      SecureBuffer<byte, 8> K1, K2;
      DES des;
   };

}

#endif
