/*************************************************
* ECB Mode Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ECB_H__
#define OPENCL_ECB_H__

#include <opencl/filter.h>
#include <opencl/modebase.h>

namespace OpenCL {

/*************************************************
* ECB Base Class                                 *
*************************************************/
class ECB : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();
      ECB(BlockCipher*, const BlockCipherKey& key, const std::string&);
   private:
      virtual void do_block(const byte[], byte[]) = 0;
   };

/*************************************************
* ECB Encryption                                 *
*************************************************/
template<typename B>
class ECB_Encryption : public ECB
   {
   public:
      ECB_Encryption(const BlockCipherKey& key) :
         ECB(new B, key, "ECB_Encryption") {}
   private:
      void do_block(const byte in[], byte out[]) { cipher->encrypt(in, out); }
   };

/*************************************************
* ECB Decryption                                 *
*************************************************/
template<typename B>
class ECB_Decryption : public ECB
   {
   public:
      ECB_Decryption(const BlockCipherKey& key) :
         ECB(new B, key, "ECB_Decryption") {}
   private:
      void do_block(const byte in[], byte out[]) { cipher->decrypt(in, out); }
   };

}

#endif
