/*************************************************
* EMAC Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EMAC_H__
#define OPENCL_EMAC_H__

#include <opencl/opencl.h>

namespace OpenCL {

class EMAC : public MessageAuthenticationCode
   {
   public:
      void clear() throw();
      std::string name() const { return "EMAC<" + f1->name() + ">"; }
      MessageAuthenticationCode* clone() const;
      EMAC(BlockCipher*);
      ~EMAC() { delete f1; delete f2; }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void key(const byte[], u32bit);
      BlockCipher* f1;
      BlockCipher* f2;
      SecureVector<byte> state;
      u32bit position;
   };

}

#endif
