/*************************************************
* EMSA2 Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EMSA2_H__
#define OPENCL_EMSA2_H__

#include <opencl/pubkey.h>

namespace OpenCL {

/*************************************************
* EMSA2                                          *
*************************************************/
template<typename H>
class EMSA2 : public SignaturePaddingMethod
   {
   public:
      SecureVector<byte> pad(const byte[], u32bit, u32bit) const;
      SecureVector<byte> unpad(const byte[], u32bit) const;
      EMSA2(HashFunction* = new H);
      ~EMSA2() { delete hash; }
   private:
      HashFunction* hash;
      byte hash_id;
      SecureVector<byte> empty_hash;
   };

}

#endif

#ifndef OPENCL_EMSA2_ICC__
#define OPENCL_EMSA2_ICC__
#include <opencl/emsa2.icc>
#endif
