/*************************************************
* Exceptions Header File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXCEPTION_H__
#define OPENCL_EXCEPTION_H__

#include <opencl/config.h>
#include <exception>
#include <string>

namespace OpenCL {

/*************************************************
* Exception Base Class                           *
*************************************************/
class Exception : public std::exception
   {
   public:
      const char* what() const throw() { return msg.c_str(); }
      Exception(const std::string& m = "Unknown Error") { set_msg(m); }
      virtual ~Exception() throw() {}
   protected:
      void set_msg(const std::string& m) { msg = "OpenCL: " + m; }
   private:
      std::string msg;
   };

/*************************************************
* Invalid_Argument Exception                     *
*************************************************/
struct Invalid_Argument : public Exception
   {
   Invalid_Argument(const std::string& str = "") : Exception(str) {}
   };

/*************************************************
* Invalid_Key_Length Exception                   *
*************************************************/
struct Invalid_Key_Length : public Invalid_Argument
   {
   Invalid_Key_Length(const std::string&, u32bit);
   };

/*************************************************
* Invalid_Block_Size Exception                   *
*************************************************/
struct Invalid_Block_Size : public Invalid_Argument
   {
   Invalid_Block_Size(const std::string&, const std::string&);
   };

/*************************************************
* Invalid_IV_Length Exception                    *
*************************************************/
struct Invalid_IV_Length : public Invalid_Argument
   {
   Invalid_IV_Length(const std::string&, u32bit);
   };

/*************************************************
* Algorithm_Not_Found Exception                  *
*************************************************/
struct Algorithm_Not_Found : public Exception
   {
   Algorithm_Not_Found(const std::string&);
   };

/*************************************************
* Input_Too_Large Exception                      *
*************************************************/
struct Input_Too_Large : public Exception
   {
   Input_Too_Large(const std::string&, u32bit, u32bit);
   };

/*************************************************
* Format_Error Exception                         *
*************************************************/
struct Format_Error : public Exception
   {
   Format_Error(const std::string& str = "") : Exception(str) {}
   };

/*************************************************
* Decoding_Error Exception                       *
*************************************************/
struct Decoding_Error : public Format_Error
   {
   Decoding_Error(const std::string& name)
      : Format_Error("A decoding error occcured in " + name) {}
   };

/*************************************************
* Stream_IO_Error Exception                      *
*************************************************/
struct Stream_IO_Error : public Exception
   {
   Stream_IO_Error(const std::string& error)
      : Exception("I/O error: " + error) {}
   };

}

#endif
