/*************************************************
* GOST Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_GOST_H__
#define OPENCL_GOST_H__

#include <opencl/opencl.h>

namespace OpenCL {

class GOST : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { EK.clear(); }
      std::string name() const { return "GOST"; }
      BlockCipher* clone() const { return new GOST; }
      GOST() : BlockCipher(8, 32) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void round(u32bit&, u32bit) const;
      static const u32bit SBOX1[256], SBOX2[256], SBOX3[256], SBOX4[256];
      SecureBuffer<u32bit, 8> EK;
   };

}

#endif
