/*************************************************
* HAVAL Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_HAVAL_H__
#define OPENCL_HAVAL_H__

#include <opencl/opencl.h>

namespace OpenCL {

class HAVAL : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 128;

      static const u32bit VERSION = 1, PASS = 5;
      void clear() throw();
      std::string name() const;
      HashFunction* clone() const { return new HAVAL(OUTPUT_LENGTH); }
   protected:
      HAVAL(u32bit hashlen) : HashFunction(hashlen, 128) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      void tailor_digest(u32bit);
      static void H1(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H2(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H3(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H4(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H5(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      SecureBuffer<byte, 128> buffer;
      SecureBuffer<u32bit, 32> M;
      SecureBuffer<u32bit, 8> digest;
      u64bit count, position;
   };

struct HAVAL_128 : public HAVAL
   {
   static const u32bit HASHLENGTH = 16;
   HAVAL_128() : HAVAL(16) {}
   };

struct HAVAL_160 : public HAVAL
   {
   static const u32bit HASHLENGTH = 20;
   HAVAL_160() : HAVAL(20) {}
   };

struct HAVAL_192 : public HAVAL
   {
   static const u32bit HASHLENGTH = 24;
   HAVAL_192() : HAVAL(24) {}
   };

struct HAVAL_224 : public HAVAL
   {
   static const u32bit HASHLENGTH = 28;
   HAVAL_224() : HAVAL(28) {}
   };

struct HAVAL_256 : public HAVAL
   {
   static const u32bit HASHLENGTH = 32;
   HAVAL_256() : HAVAL(32) {}
   };

}

#endif

