/*************************************************
* IDEA Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_IDEA_H__
#define OPENCL_IDEA_H__

#include <opencl/opencl.h>

namespace OpenCL {

class IDEA : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { EK.clear(); DK.clear(); }
      std::string name() const { return "IDEA"; }
      BlockCipher* clone() const { return new IDEA; }
      IDEA() : BlockCipher(8, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static void mul(u16bit&, u16bit);
      static u16bit mul_inv(u16bit);
      SecureBuffer<u16bit, 52> EK, DK;
   };

}

#endif
