/*************************************************
* ISAAC Header File                              *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ISAAC_H__
#define OPENCL_ISAAC_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ISAAC : public StreamCipher
   {
   public:
      void clear() throw();
      std::string name() const { return "ISAAC"; }
      StreamCipher* clone() const { return new ISAAC; }
      ISAAC() : StreamCipher(1, 32) { clear(); }
      ~ISAAC() { clear(); }
   private:
      void cipher(const byte[], byte[], u32bit);
      void key(const byte[], u32bit);
      void generate();
      SecureBuffer<u32bit, 256> state;
      SecureBuffer<byte, 1024> buffer;
      u32bit A, B, C, position;
   };

}

#endif
