/*************************************************
* KDF1 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_KDF1_H__
#define OPENCL_KDF1_H__

#include <opencl/pk_misc.h>

namespace OpenCL {

/*************************************************
* KDF1                                           *
*************************************************/
class KDF1 : public KeyDerivationFunction
   {
   public:
      SymmetricKey derive(const byte[], u32bit, u32bit) const;
      KDF1(HashFunction*, const std::string& = "");
      ~KDF1() { delete hash; }
   private:
      HashFunction* hash;
      SecureVector<byte> P;
   };

}

#endif
