/*************************************************
* Algorithm Lookup Header File                   *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_LOOKUP_H__
#define OPENCL_LOOKUP_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* Retrieve an algorithm from the lookup table    *
*************************************************/
BlockCipher* get_block_cipher(const std::string&);
StreamCipher* get_stream_cipher(const std::string&);
HashFunction* get_hash(const std::string&);
MessageAuthenticationCode* get_mac(const std::string&);

/*************************************************
* Add an algorithm to the lookup table           *
*************************************************/
void add_algorithm(BlockCipher*);
void add_algorithm(StreamCipher*);
void add_algorithm(HashFunction*);
void add_algorithm(MessageAuthenticationCode*);

}

#endif
