/*************************************************
* MD2 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MD2_H__
#define OPENCL_MD2_H__

#include <opencl/opencl.h>

namespace OpenCL {

class MD2 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 16, HASHLENGTH = 16;

      void clear() throw();
      std::string name() const { return "MD2"; }
      HashFunction* clone() const { return new MD2; }
      MD2() : HashFunction(16, 16) { position = 0; }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static const byte SBOX[256];
      SecureBuffer<byte, 48> X;
      SecureBuffer<byte, 16> buffer, checksum;
      u64bit position;
   };

}

#endif
