/*************************************************
* MD4 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MD4_H__
#define OPENCL_MD4_H__

#include <opencl/opencl.h>

namespace OpenCL {

class MD4 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 16;

      void clear() throw();
      std::string name() const { return "MD4"; }
      HashFunction* clone() const { return new MD4; }
      MD4() : HashFunction(16, 64) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void FF(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      static void GG(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      static void HH(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      SecureBuffer<byte, 64> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest;
      u64bit count, position;
   };

}

#endif
