/*************************************************
* MD5-MAC Header File                            *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MD5MAC_H__
#define OPENCL_MD5MAC_H__

#include <opencl/opencl.h>

namespace OpenCL {

class MD5MAC : public MessageAuthenticationCode
   {
   public:
      void clear() throw();
      std::string name() const { return "MD5-MAC"; }
      MessageAuthenticationCode* clone() const { return new MD5MAC; }
      MD5MAC();
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void key(const byte[], u32bit);
      void hash(const byte[]);
      void FF(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void GG(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void HH(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void II(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      SecureBuffer<byte, 64> buffer, K3;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest, K1, K2;
      u64bit count, position;
   };

}

#endif
