/*************************************************
* CBC Padding Methods Header File                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PADDING_H__
#define OPENCL_PADDING_H__

#include <opencl/opencl.h>

namespace OpenCL {

class BlockCipherModePaddingMethod
   {
   public:
      virtual void pad(byte[], u32bit, u32bit) const = 0;
      virtual u32bit unpad(const byte[], u32bit) const = 0;
      virtual u32bit pad_bytes(u32bit, u32bit) const = 0;
      virtual bool valid_blocksize(u32bit) const = 0;
      virtual std::string name() const = 0;
   };

class PKCS7_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const;
      u32bit unpad(const byte[], u32bit) const;
      u32bit pad_bytes(u32bit bs, u32bit pos) const { return (bs - pos); }
      bool valid_blocksize(u32bit) const;
      std::string name() const { return "PKCS7"; }
   };

class OneAndZeros_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const;
      u32bit unpad(const byte[], u32bit) const;
      u32bit pad_bytes(u32bit bs, u32bit pos) const { return (bs - pos); }
      bool valid_blocksize(u32bit) const;
      std::string name() const { return "OneAndZeros"; }
   };

class Null_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const { return; }
      u32bit unpad(const byte[], u32bit size) const { return size; }
      u32bit pad_bytes(u32bit, u32bit) const { return 0; }
      bool valid_blocksize(u32bit) const { return true; }
      std::string name() const { return "Null"; }
   };

// DEPRECATED ALIASES
typedef PKCS7_Padding PKCSPadding;
typedef OneAndZeros_Padding OneAndZeros;
typedef Null_Padding NoPadding;
// END DEPRECATED ALIASES

}

#endif
