/*************************************************
* Cipher Mode Base Header File                   *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MODEBASE_H__
#define OPENCL_MODEBASE_H__

#include <opencl/opencl.h>
#include <string>

namespace OpenCL {

typedef SymmetricKey BlockCipherModeIV;

/*************************************************
* Block Cipher Mode Base Class                   *
*************************************************/
class BlockCipherMode
   {
   public:
      std::string name() const;
      void reset_iv(const BlockCipherModeIV&);

      BlockCipherMode(BlockCipher*, const std::string&, const BlockCipherKey&,
                      const BlockCipherModeIV&, u32bit = 1);

      ~BlockCipherMode() { delete cipher; }
   protected:
      const u32bit BLOCK_SIZE, BUFFER_SIZE;
      const std::string mode_name;
      BlockCipher* cipher;
      SecureVector<byte> buffer, state;
      u32bit position;
   };

}

#endif
