/*************************************************
* Number Theory Header File                      *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_NUMBTHRY_H__
#define OPENCL_NUMBTHRY_H__

#include <opencl/bigint.h>
#include <opencl/reducer.h>
#include <opencl/fused.h>

namespace OpenCL {

/*************************************************
* Number Theory Functions                        *
*************************************************/
inline BigInt abs(const BigInt& n) { return n.abs(); }

BigInt gcd(const BigInt&, const BigInt&);
BigInt lcm(const BigInt&, const BigInt&);

void divide(const BigInt&, const BigInt&, BigInt&, BigInt&);
void positive_divide_nonmodify(const BigInt&, const BigInt&, BigInt&, BigInt&);
void positive_divide(BigInt&, BigInt&, BigInt&, BigInt&);

BigInt square(const BigInt&);
BigInt inverse_mod(const BigInt&, const BigInt&);
BigInt power(const BigInt&, u32bit);

BigInt power_mod(const BigInt&, const BigInt&, const BigInt&);
BigInt power_mod(const BigInt&, const BigInt&, ModularReducer*);

bool is_prime(const BigInt&);
bool strong_probable_prime(const BigInt&, const BigInt&, u32bit, const BigInt&,
                           ModularReducer*);

/*************************************************
* Random Number Generation                       *
*************************************************/
BigInt random_integer(u32bit);
BigInt random_prime(u32bit);
BigInt random_safe_prime(u32bit);

}

#endif
