/*************************************************
* OFB Mode Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_OFB_H__
#define OPENCL_OFB_H__

#include <opencl/filter.h>
#include <opencl/modebase.h>

namespace OpenCL {

/*************************************************
* OFB                                            *
*************************************************/
template<typename B>
class OFB : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      OFB(const BlockCipherKey&, const BlockCipherModeIV&);
   };

/*************************************************
* Counter                                        *
*************************************************/
template<typename B>
class Counter : public BlockCipherMode, public Filter
   {
   public:
      void write(const byte[], u32bit);
      Counter(const BlockCipherKey&, const BlockCipherModeIV&);
   };

}

#endif

#ifndef OPENCL_OFB_ICC__
#define OPENCL_OFB_ICC__
#include <opencl/ofb.icc>
#endif
