/*************************************************
* Pipe Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PIPE_H__
#define OPENCL_PIPE_H__

#include <opencl/filter.h>
#include <iosfwd>
#include <vector>
#include <cstdio>

namespace OpenCL {

/*************************************************
* Pipe                                           *
*************************************************/
class Pipe
   {
   public:
      void write(const byte[], u32bit);
      void write(byte input) { write(&input, 1); }
      void write(const std::string&);

      u32bit read(byte[], u32bit);
      u32bit read(byte& out) { return read(&out, 1); }
      SecureVector<byte> read_all();
      std::string read_all_as_string();
      u32bit remaining() const { return remaining(default_msg()); }

      u32bit read(u32bit, byte[], u32bit);
      u32bit read(u32bit, byte&);
      SecureVector<byte> read_all(u32bit);
      std::string read_all_as_string(u32bit);
      u32bit remaining(u32bit) const;

      u32bit peek(u32bit, byte[], u32bit);
      u32bit peek(u32bit, byte&);

      u32bit default_msg() const { return default_read; }
      void set_default_msg(u32bit);
      u32bit message_count() const { return messages.size(); }

      void start_msg();
      void end_msg();

      void prepend(Filter*);
      void append(Filter*);
      void pop();
      void reset() { destruct(pipe); init(); }

      Pipe(Filter* = 0, Filter* = 0, Filter* = 0, Filter* = 0);
      Pipe(Filter*[], u32bit);
      ~Pipe() { destroy(pipe); }
   private:
      Pipe(const Pipe&) {}
      void operator=(const Pipe&) {}
      void init();
      void destruct(Filter*);
      void find_endpoints(Filter*);
      std::vector<class SecureQueue*> messages;
      Filter* pipe;
      bool locked;
      u32bit default_read;
   };

/*************************************************
* Input and Ouput Operators for Pipe             *
*************************************************/
std::ostream& operator<<(std::ostream&, Pipe&);
std::istream& operator>>(std::istream&, Pipe&);

std::FILE* operator<<(std::FILE*, Pipe&);
std::FILE* operator>>(std::FILE*, Pipe&);

}

#endif
