/*************************************************
* Public Key Base Classes Header File            *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PK_BASE_H__
#define OPENCL_PK_BASE_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* Public Key Encryptor Base Class                *
*************************************************/
class PK_Encryptor
   {
   public:
      virtual SecureVector<byte> encrypt(const byte[], u32bit) const = 0;
      virtual ~PK_Encryptor() {}
   };

/*************************************************
* Public Key Decryptor Base Class                *
*************************************************/
class PK_Decryptor
   {
   public:
      virtual SecureVector<byte> decrypt(const byte[], u32bit) const = 0;
      virtual ~PK_Decryptor() {}
   };

/*************************************************
* Public Key Signer Base Class                   *
*************************************************/
class PK_Signer
   {
   public:
      virtual void update(const byte[], u32bit) = 0;
      virtual SecureVector<byte> signature() = 0;
      virtual ~PK_Signer() {}
   };

/*************************************************
* Public Key Verifier Base Class                 *
*************************************************/
class PK_Verifier
   {
   public:
      virtual void update(const byte[], u32bit) = 0;
      virtual bool valid_signature(const byte[], u32bit) = 0;
      virtual ~PK_Verifier() {}
   };

}

#endif
