/*************************************************
* Miscellaneous PK Functions Header File         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PUBKEY_MISC_H__
#define OPENCL_PUBKEY_MISC_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* Message Encoding Method Base Class             *
*************************************************/
struct MessageEncodingMethod
   {
   virtual SecureVector<byte> pad(const byte[], u32bit, u32bit) const = 0;
   virtual SecureVector<byte> unpad(const byte[], u32bit) const = 0;
   virtual ~MessageEncodingMethod() {}
   };

/*************************************************
* Signature Padding Method Base Class            *
*************************************************/
struct SignaturePaddingMethod
   {
   virtual SecureVector<byte> pad(const byte[], u32bit, u32bit) const = 0;
   virtual SecureVector<byte> unpad(const byte[], u32bit) const = 0;
   virtual ~SignaturePaddingMethod() {}
   };

/*************************************************
* Mask Generation Function Base Class            *
*************************************************/
struct MaskGenerationFunction
   {
   virtual void mask(const byte[], u32bit, byte[], u32bit) = 0;
   virtual ~MaskGenerationFunction() {}
   };

/*************************************************
* Key Derivation Function Base Class             *
*************************************************/
struct KeyDerivationFunction
   {
   virtual SymmetricKey derive(const byte[], u32bit, u32bit) const = 0;
   virtual ~KeyDerivationFunction() {}
   };

}

#endif
