/*************************************************
* Public Key Types Header File                   *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PK_TYPES_H__
#define OPENCL_PK_TYPES_H__

#include <opencl/pubkey.h>
#include <opencl/ieee1363.h>
#include <opencl/pk_raw.h>

#include <opencl/rsa.h>
#include <opencl/sha1.h>

namespace OpenCL {

/*************************************************
* RSA Encryption Schemes                         *
*************************************************/
typedef IF_Scheme_Encryptor<RSA_PublicKey, EME1<SHA1> >
   RSA_EME1_SHA1_Encryptor;

typedef IF_Scheme_Decryptor<RSA_PrivateKey, EME1<SHA1> >
   RSA_EME1_SHA1_Decryptor;

typedef IF_Scheme_Encryptor<RSA_PublicKey, PK_NoPadding>
   RSA_Raw_Encryptor;

typedef IF_Scheme_Decryptor<RSA_PrivateKey, PK_NoPadding>
   RSA_Raw_Decryptor;

/*************************************************
* RSA Signature Schemes                          *
*************************************************/
typedef IF_Scheme_Signer<RSA_PrivateKey, SHA1, EMSA2<SHA1> >
   RSA_EMSA2_SHA1_Signer;

typedef IF_Scheme_Verifier<RSA_PublicKey, SHA1, EMSA2<SHA1> >
   RSA_EMSA2_SHA1_Verifier;

typedef IF_Scheme_Signer<RSA_PrivateKey, SHA1, PK_NoPadding>
   RSA_Raw_SHA1_Signer;

typedef IF_Scheme_Verifier<RSA_PublicKey, SHA1, PK_NoPadding>
   RSA_Raw_SHA1_Verifier;

}

#endif
