/*************************************************
* Public Key Interface Header File               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_PUBKEY_H__
#define OPENCL_PUBKEY_H__

#include <opencl/pk_base.h>
#include <opencl/pk_misc.h>

namespace OpenCL {

/*************************************************
* IF_Scheme_Encryptor                            *
*************************************************/
template<typename PK, typename PAD>
class IF_Scheme_Encryptor : public PK_Encryptor
   {
   public:
      SecureVector<byte> encrypt(const byte[], u32bit) const;
      IF_Scheme_Encryptor(PK& k) : key(k) { padder = new PAD; }
      ~IF_Scheme_Encryptor() { delete padder; }
   private:
      MessageEncodingMethod* padder;
      const PK& key;
   };

/*************************************************
* IF_Scheme_Decryptor                            *
*************************************************/
template<typename PK, typename PAD>
class IF_Scheme_Decryptor : public PK_Decryptor
   {
   public:
      SecureVector<byte> decrypt(const byte[], u32bit) const;
      IF_Scheme_Decryptor(PK& k) : key(k) { padder = new PAD; }
      ~IF_Scheme_Decryptor() { delete padder; }
   private:
      MessageEncodingMethod* padder;
      const PK& key;
   };

/*************************************************
* IF_Scheme_Verifier                             *
*************************************************/
template<typename PK, typename H, typename PAD>
class IF_Scheme_Verifier : public PK_Verifier
   {
   public:
      void update(const byte in[], u32bit length) { hash->update(in, length); }
      bool valid_signature(const byte[], u32bit);
      IF_Scheme_Verifier(PK& k) : key(k) { padder = new PAD; hash = new H; }
      ~IF_Scheme_Verifier() { delete padder; delete hash; }
   private:
      HashFunction* hash;
      SignaturePaddingMethod* padder;
      const PK& key;
   };

/*************************************************
* IF_Scheme_Singer                               *
*************************************************/
template<typename PK, typename H, typename PAD>
class IF_Scheme_Signer : public PK_Signer
   {
   public:
      void update(const byte in[], u32bit length) { hash->update(in, length); }
      SecureVector<byte> signature();
      IF_Scheme_Signer(PK& k) : key(k) { padder = new PAD; hash = new H; }
      ~IF_Scheme_Signer() { delete padder; delete hash; }
   private:
      HashFunction* hash;
      SignaturePaddingMethod* padder;
      const PK& key;
   };

}

#endif

#ifndef OPENCL_PUBKEY_ICC__
#define OPENCL_PUBKEY_ICC__
#include <opencl/pubkey.icc>
#endif
