/*************************************************
* Randpool Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RANDPOOL_H__
#define OPENCL_RANDPOOL_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Randpool : public RandomNumberGenerator
   {
   public:
      byte random();
      void randomize(byte[], u32bit);
      void clear() throw();
      std::string name() const { return "Randpool"; }
      Randpool(u32bit = 12);
      ~Randpool() { delete hash; }
   private:
      void add_randomness(const byte[], u32bit) throw();
      void generate(u64bit);
      void mix_pool();
      void reseed();
      HashFunction* hash;
      SecureVector<byte> pool;
      SecureVector<byte> buffer;
      u32bit position, iteration;
   };

}

#endif
