/*************************************************
* RC2 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RC2_H__
#define OPENCL_RC2_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RC2 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      void clear() throw() { K.clear(); }
      std::string name() const { return "RC2"; }
      BlockCipher* clone() const { return new RC2; }
      RC2() : BlockCipher(8, 1, 32) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void mash(u16bit&, u16bit&, u16bit&, u16bit&) const;
      void rmash(u16bit&, u16bit&, u16bit&, u16bit&) const;
      void mix(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      void rmix(u16bit&, u16bit&, u16bit&, u16bit&, u32bit) const;
      static const byte TABLE[256];
      SecureBuffer<u16bit, 64> K;
   };

}

#endif
