/*************************************************
* RC5 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RC5_H__
#define OPENCL_RC5_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RC5 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8, DEFAULT_ROUNDS = 16;

      void clear() throw() { S.clear(); }
      std::string name() const { return "RC5-" + to_string(ROUNDS); }
      BlockCipher* clone() const { return new RC5(ROUNDS); }
      RC5(u32bit r = DEFAULT_ROUNDS);
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      SecureVector<u32bit> S;
      const u32bit ROUNDS;
   };

struct RC5_12 : public RC5
   {
   RC5_12() : RC5(12) {}
   };

struct RC5_16 : public RC5
   {
   RC5_16() : RC5(16) {}
   };

}

#endif
