/*************************************************
* RC6 Header File                                *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RC6_H__
#define OPENCL_RC6_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RC6 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 16;

      void clear() throw() { S.clear(); }
      std::string name() const { return "RC6"; }
      BlockCipher* clone() const { return new RC6; }
      RC6() : BlockCipher(16, 1, 32) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      void encrypt_round(u32bit&, u32bit, u32bit&, u32bit, u32bit) const;
      void decrypt_round(u32bit&, u32bit, u32bit&, u32bit, u32bit) const;
      SecureBuffer<u32bit, 44> S;
   };

}

#endif
