/*************************************************
* Rijndael Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RIJNDAEL_H__
#define OPENCL_RIJNDAEL_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Rijndael : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 16;

      void clear() throw();
      std::string name() const { return "Rijndael"; }
      BlockCipher* clone() const { return new Rijndael; }
      Rijndael() : BlockCipher(16, 16, 32, 8) {}
   public:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static u32bit S(u32bit);
      static const byte SE[256], SD[256];
      static const u32bit TE0[256], TE1[256], TE2[256], TE3[256],
                          TD0[256], TD1[256], TD2[256], TD3[256];
      SecureBuffer<u32bit, 52> EK, DK;
      SecureBuffer<byte, 32> ME, MD;
      u32bit ROUNDS;
   };

typedef Rijndael AES;

}

#endif
