/*************************************************
* RIPEMD-128 Header File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RIPEMD_128_H__
#define OPENCL_RIPEMD_128_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RIPEMD_128 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 16;

      void clear() throw();
      std::string name() const { return "RIPEMD-128"; }
      HashFunction* clone() const { return new RIPEMD_128; }
      RIPEMD_128() : HashFunction(16, 64) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F2(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F3(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F4(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      SecureBuffer<byte, 64> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest;
      u64bit count, position;
   };

}

#endif
