/*************************************************
* RIPEMD-160 Header File                         *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RIPEMD_160_H__
#define OPENCL_RIPEMD_160_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RIPEMD_160 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 20;

      void clear() throw();
      std::string name() const { return "RIPEMD-160"; }
      HashFunction* clone() const { return new RIPEMD_160; }
      RIPEMD_160() : HashFunction(20, 64) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F2(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F3(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F4(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F5(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      SecureBuffer<byte, 64> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 5> digest;
      u64bit count, position;
   };

}

#endif
