/*************************************************
* SAFER-SK128 Header File                        *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SAFER_SK128_H__
#define OPENCL_SAFER_SK128_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SAFER_SK128 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8;

      static const u32bit DEFAULT_ROUNDS = 10, MAX_ROUNDS = 13;
      void clear() throw();
      std::string name() const { return "SAFER-SK128-" + to_string(ROUNDS); }
      BlockCipher* clone() const { return new SAFER_SK128(ROUNDS); }
      SAFER_SK128(u32bit = DEFAULT_ROUNDS);
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static const byte EXP[256], LOG[512], BIAS[208], KEY_INDEX[208];
      SecureBuffer<byte, 256> SE[104], SD[104];
      SecureBuffer<byte, 8> MK;
      const u32bit ROUNDS;
   };

}

#endif
