/*************************************************
* SHA1 Header File                               *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SHA1_H__
#define OPENCL_SHA1_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SHA1 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 20;

      void clear() throw();
      std::string name() const { return "SHA-1"; }
      HashFunction* clone() const { return new SHA1; }
      SHA1() : HashFunction(20, 64) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F2(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F3(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F4(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      SecureBuffer<byte, 64> buffer;
      SecureBuffer<u32bit, 80> W;
      SecureBuffer<u32bit, 5> digest;
      u64bit count, position;
      friend class Gamma;
   };

}

#endif
