/*************************************************
* SHA2-384 Header File                           *
* (C) 1999-2002 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SHA2_384_H__
#define OPENCL_SHA2_384_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SHA2_384 : public HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "SHA2-384"; }
      HashFunction* clone() const { return new SHA2_384; }
      SHA2_384() : HashFunction(48, 128) { clear(); }
   private:
      void add_data(const byte[], u32bit);
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u64bit, u64bit, u64bit, u64bit&, u64bit,
                     u64bit, u64bit, u64bit&, u64bit, u64bit);
      static u64bit rho(u64bit, u32bit, u32bit, u32bit);
      static u64bit sigma(u64bit, u32bit, u32bit, u32bit);
      SecureBuffer<byte, 128> buffer;
      SecureBuffer<u64bit, 80> W;
      SecureBuffer<u64bit, 8> digest;
      u64bit count, position;
   };

}

#endif
